/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.ItemInput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class RitualRecipe
implements DisplayableRecipe<RitualContainer> {
    public static final TypedSerializer<RitualRecipe> TYPED_SERIALIZER = new TypedSerializer<RitualRecipe>(CropariaIf.of("ritual"), RitualRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockInput.CODEC.fieldOf("ritual").forGetter(RitualRecipe::getRitual), (App)BlockInput.CODEC.fieldOf("block").forGetter(RitualRecipe::getBlock), (App)ItemInput.CODEC.fieldOf("ingredient").forGetter(RitualRecipe::getIngredient), (App)ItemOutput.CODEC.fieldOf("result").forGetter(RitualRecipe::getResult)).apply((Applicative)instance, RitualRecipe::new)), TypedSerializer.JEI, Mappable.of(CropariaItems.RITUAL_STAND, item -> Texts.tooltip(item.method_7854(), Constants.TOOLTIP_RITUAL)), Mappable.of(CropariaItems.RITUAL_STAND_2, item -> Texts.tooltip(item.method_7854(), Constants.TOOLTIP_RITUAL)), Mappable.of(CropariaItems.RITUAL_STAND_3, item -> Texts.tooltip(item.method_7854(), Constants.TOOLTIP_RITUAL)));
    private final BlockInput ritual;
    @NotNull
    private final BlockInput block;
    @NotNull
    private final ItemInput ingredient;
    @NotNull
    private final ItemOutput result;

    public RitualRecipe(BlockInput ritual, @NotNull BlockInput state, @NotNull ItemInput ingredient, @NotNull ItemOutput result) {
        this.ritual = ritual;
        this.block = state;
        this.ingredient = ingredient;
        this.result = result;
        this.ritual.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.TOOLTIP_RITUAL));
            return stacks;
        });
        this.ingredient.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.ITEM_DROP_TOOLTIP));
            return stacks;
        });
        this.block.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.BLOCK_PLACE_TOOLTIP));
            return stacks;
        });
    }

    @NotNull
    public ItemInput getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public ItemOutput getResult() {
        return this.result;
    }

    @NotNull
    public BlockInput getBlock() {
        return this.block;
    }

    @NotNull
    public BlockInput getRitual() {
        return this.ritual;
    }

    @Override
    @NotNull
    public List<List<class_1799>> getInputs() {
        return List.of(this.getIngredient().getDisplayStacks(), this.getBlock().getDisplayStacks());
    }

    @Override
    @NotNull
    public List<List<class_1799>> getOutputs() {
        class_1799 stack = this.getResult().getDisplayStack().method_7972();
        if (stack.method_7909() instanceof class_1826) {
            Texts.tooltip(stack, Texts.translatable("tooltip.croparia.spawn_egg", new Object[0]));
        } else if (stack.method_7909() == class_1802.field_8598 && this.getIngredient().getAmount() == 1L) {
            Texts.tooltip(stack, Texts.translatable("tooltip.croparia.ritual.enchant", stack.method_7947()));
        }
        return List.of(List.of(stack));
    }

    public class_1799 assemble(RitualContainer matcher) {
        class_1799 result = this.getResult().createStack();
        class_9304 enchantments = (class_9304)result.method_57824(class_9334.field_49643);
        if (this.getIngredient().getAmount() == 1L && result.method_7909() == class_1802.field_8598 && enchantments != null) {
            for (class_1799 stack : matcher.stacks()) {
                if (!this.getIngredient().matchType(stack)) continue;
                matcher.matched().destroy();
                class_1799 toEnchant = stack.method_46651(1);
                stack.method_7934(1);
                for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                    int level = toEnchant.method_58657().method_57536((class_6880)entry.getKey());
                    toEnchant.method_7978((class_6880)entry.getKey(), Math.min(level + result.method_7947(), entry.getIntValue()));
                }
                return toEnchant;
            }
            return class_1799.field_8037;
        }
        long consumed = 0L;
        for (class_1799 stack : matcher.stacks()) {
            if (this.getIngredient().matchType(stack)) {
                long toConsume = Math.min((long)stack.method_7947(), this.getIngredient().getAmount() - consumed);
                stack.method_7934(Math.toIntExact(toConsume));
                consumed += toConsume;
            }
            if (consumed < this.getIngredient().getAmount()) continue;
            matcher.matched().destroy();
            return this.getResult().createStack();
        }
        return class_1799.field_8037;
    }

    public boolean matches(RitualContainer matcher) {
        class_1799 result = this.getResult().createStack();
        if (!this.getRitual().matches(matcher.ritual())) {
            return false;
        }
        class_9304 enchantments = (class_9304)result.method_57824(class_9334.field_49643);
        if (this.getIngredient().getAmount() == 1L && result.method_7909() == class_1802.field_8598 && enchantments != null) {
            return matcher.stacks().stream().anyMatch(stack -> {
                class_9304 toCheck = stack.method_58657();
                return enchantments.method_57539().stream().anyMatch(entry -> toCheck.method_57536((class_6880)entry.getKey()) < entry.getIntValue()) && this.getIngredient().matches((class_1799)stack);
            }) && matcher.matched().getStates().stream().allMatch(state -> this.getBlock().matches((class_2680)state));
        }
        return this.getIngredient().matches(matcher) && matcher.matched().getStates().stream().allMatch(state -> this.getBlock().matches((class_2680)state));
    }

    public boolean matches(RitualContainer container, class_1937 level) {
        return this.matches(container);
    }

    @NotNull
    public class_1799 assemble(RitualContainer recipeInput, class_7225.class_7874 provider) {
        return this.assemble(recipeInput);
    }

    @NotNull
    public ItemOutput result() {
        return this.getResult();
    }

    @NotNull
    public BlockInput craftingStation() {
        return this.getRitual();
    }

    @Override
    public TypedSerializer<? extends DisplayableRecipe<RitualContainer>> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RitualRecipe)) {
            return false;
        }
        RitualRecipe that = (RitualRecipe)o;
        return Objects.equals(this.ritual, that.ritual) && Objects.equals(this.block, that.block) && Objects.equals(this.ingredient, that.ingredient) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.ritual, this.block, this.ingredient, this.result);
    }
}

