/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.core.item.Placeholder;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.structure.Char3D;
import cool.muyucloud.croparia.api.recipe.structure.MarkedChar3D;
import cool.muyucloud.croparia.api.recipe.structure.MarkedTransformableChar3D;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import cool.muyucloud.croparia.util.supplier.Mappable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class RitualStructure
implements DisplayableRecipe<RitualStructureContainer> {
    public static final TypedSerializer<RitualStructure> TYPED_SERIALIZER = new TypedSerializer<RitualStructure>(CropariaIf.of("ritual_structure"), RitualStructure.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockInput.CODEC.fieldOf("ritual").forGetter(RitualStructure::getRitual), (App)Codec.unboundedMap(CodecUtil.CHAR, BlockInput.CODEC).fieldOf("keys").forGetter(RitualStructure::getKeys), (App)Char3D.CODEC.fieldOf("pattern").forGetter(RitualStructure::getPattern)).apply((Applicative)instance, RitualStructure::new)), TypedSerializer.ALWAYS, new Mappable[0]);
    public static final LazySupplier<class_1799> STACK_INPUT = LazySupplier.of(() -> {
        class_1799 stack = ((Placeholder)((Object)((Object)CropariaItems.PLACEHOLDER.get()))).method_7854();
        stack.method_57379(class_9334.field_49631, (Object)Constants.INPUT_BLOCK);
        return stack;
    });
    private final BlockInput ritual;
    @NotNull
    private final ImmutableMap<Character, BlockInput> keys;
    @NotNull
    private final MarkedTransformableChar3D patterns;
    private final transient LazySupplier<List<List<class_1799>>> inputsCache = LazySupplier.of(() -> {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getPattern().forEachChar((key, count) -> {
            if (key.charValue() == '*') {
                builder.add(this.getRitual().getDisplayStacks());
            } else if (key.charValue() != '.' && key.charValue() != ' ' && key.charValue() != '$') {
                BlockInput input = this.getKeys().get(key);
                if (input != null) {
                    builder.add(input.getDisplayStacks().stream().map(stack -> stack.method_46651(count.intValue())).toList());
                } else {
                    builder.add(List.of());
                }
            }
        });
        return builder.build();
    });

    public RitualStructure(BlockInput ritual, @NotNull Map<Character, BlockInput> keyDeclarations, Char3D rawPattern) {
        this.ritual = ritual;
        HashMap<Character, BlockInput> keys = new HashMap<Character, BlockInput>();
        for (Character c : keyDeclarations.keySet()) {
            if (c.charValue() == '*' || c.charValue() == '$' || c.charValue() == '.' || c.charValue() == ' ') {
                throw new IllegalArgumentException("Preserved key: " + c);
            }
            keys.put(c, keyDeclarations.get(c));
        }
        this.keys = ImmutableMap.copyOf(keys);
        for (char c : rawPattern.chars()) {
            if (this.keys.containsKey((Object)Character.valueOf(c)) || c == '$' || c == '*' || c == '.' || c == ' ') continue;
            throw new IllegalArgumentException("Unknown key: " + c);
        }
        if (!rawPattern.contains('$')) {
            throw new IllegalArgumentException("Ritual structure must contains a block input ($).");
        }
        class_2382 mark = rawPattern.find('*').orElseThrow(() -> new IllegalArgumentException("Ritual structure must contains a ritual mark (*)."));
        this.patterns = new MarkedTransformableChar3D(rawPattern, mark);
    }

    public BlockInput getRitual() {
        return this.ritual;
    }

    @Override
    @NotNull
    public List<List<class_1799>> getInputs() {
        return this.inputsCache.get();
    }

    @Override
    @NotNull
    public List<List<class_1799>> getOutputs() {
        return List.of(this.getRitual().getDisplayStacks());
    }

    @NotNull
    public Result matchTransformed(class_2338 origin, class_1937 level, MarkedChar3D pattern, class_2680 ritualBlock) {
        origin = pattern.getOriginInWorld(origin);
        ArrayList<class_2338> inputPositions = new ArrayList<class_2338>();
        ArrayList<class_2680> inputBlocks = new ArrayList<class_2680>();
        for (int x = 0; x < pattern.xSize(); ++x) {
            for (int y = 0; y < pattern.ySize(); ++y) {
                for (int z = 0; z < pattern.zSize(); ++z) {
                    BlockInput input;
                    class_2338 pos = origin.method_10069(x, y, z);
                    class_2680 state = level.method_8320(pos);
                    char key = pattern.get(x, y, z);
                    if (key == '$') {
                        inputPositions.add(pos);
                        inputBlocks.add(state);
                        continue;
                    }
                    if (!(key == '*' ? !state.equals(ritualBlock) : (key == '.' ? !state.method_26215() : key != ' ' && ((input = (BlockInput)this.keys.get((Object)Character.valueOf(key))) == null || !input.matches(state))))) continue;
                    return Result.FAIL;
                }
            }
        }
        return RitualStructure.result(inputBlocks, () -> {
            for (class_2338 pos : inputPositions) {
                level.method_22352(pos, false);
            }
        });
    }

    public Result validate(class_2338 origin, class_1937 level) {
        for (MarkedChar3D pattern : this.patterns) {
            Result result = this.matchTransformed(origin, level, pattern, level.method_8320(origin));
            if (result == Result.FAIL) continue;
            return result;
        }
        return Result.FAIL;
    }

    @NotNull
    public Map<Character, BlockInput> getKeys() {
        return this.keys;
    }

    public MarkedChar3D getPattern() {
        return this.patterns.getOriginal();
    }

    public List<class_1799> displaySlot(int x, int y, int z) {
        return switch (this.getPattern().get(x, y, z)) {
            case ' ' -> List.of(BlockInput.STACK_ANY);
            case '$' -> List.of(STACK_INPUT.get());
            case '*' -> this.getRitual().getDisplayStacks();
            case '.' -> List.of(BlockInput.STACK_AIR);
            default -> {
                BlockInput input = (BlockInput)this.keys.get((Object)Character.valueOf(this.getPattern().get(x, y, z)));
                if (input != null) {
                    yield input.getDisplayStacks();
                }
                yield List.of();
            }
        };
    }

    public boolean isVirtualRender(int x, int y, int z) {
        char c = this.getPattern().get(x, y, z);
        return c == ' ' || c == '$' || c == '.' || c != '*' && Objects.requireNonNull((BlockInput)this.keys.get((Object)Character.valueOf(c))).isVirtualRender();
    }

    public void tryBuild(class_1937 level, class_2338 origin) {
        MarkedChar3D pattern = this.getPattern();
        origin = pattern.getOriginInWorld(origin);
        for (int x = 0; x < pattern.xSize(); ++x) {
            for (int y = 0; y < pattern.ySize(); ++y) {
                for (int z = 0; z < pattern.zSize(); ++z) {
                    char key = pattern.get(x, y, z);
                    if (key == '.') {
                        level.method_8501(origin.method_10069(x, y, z), class_2246.field_10124.method_9564());
                        continue;
                    }
                    if (key == '$') {
                        level.method_8501(origin.method_10069(x, y, z), ((cool.muyucloud.croparia.api.core.block.Placeholder)((Object)CropariaBlocks.PLACEHOLDER.get())).method_9564());
                        continue;
                    }
                    if (key == ' ' || key == '*') continue;
                    level.method_8501(origin.method_10069(x, y, z), this.getKeys().get(Character.valueOf(key)).getExampleState());
                }
            }
        }
    }

    public class_2382 size() {
        return this.getPattern().size();
    }

    @Override
    public TypedSerializer<? extends RitualStructure> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    public boolean matches(RitualStructureContainer matcher, class_1937 level) {
        return this.getRitual().matches(matcher.getState());
    }

    @Deprecated
    @NotNull
    public class_1799 assemble(RitualStructureContainer recipeInput, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    public static Result result(List<class_2680> states, @NotNull Runnable destroyAction) {
        return new Result(states, destroyAction);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RitualStructure)) {
            return false;
        }
        RitualStructure structure = (RitualStructure)o;
        return Objects.equals(this.ritual, structure.ritual) && Objects.equals(this.keys, structure.keys) && Objects.equals(this.patterns, structure.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.ritual, this.keys, this.patterns);
    }

    public static class Result {
        public static final Result FAIL = new Result(List.of(), () -> {});
        @NotNull
        private final List<class_2680> states;
        @NotNull
        private final Runnable destroyAction;

        public Result(@NotNull List<class_2680> states, @NotNull Runnable destroyAction) {
            this.states = states;
            this.destroyAction = destroyAction;
        }

        @NotNull
        public List<class_2680> getStates() {
            return this.states;
        }

        public void destroy() {
            this.destroyAction.run();
        }

        public void ifSuccessOrElse(Consumer<Result> state, Runnable onFail) {
            if (this.getStates().isEmpty()) {
                onFail.run();
            } else {
                state.accept(this);
            }
        }
    }
}

