/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.util;

import cool.muyucloud.croparia.api.core.component.TargetPos;
import cool.muyucloud.croparia.util.CifUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;

public class DropsCache {
    private static final Map<TargetPos, Long> CACHE = new HashMap<TargetPos, Long>();

    public static boolean isQueried(class_1937 level, class_2338 pos, long duration) {
        TargetPos targetPos = new TargetPos(level, pos);
        long lastQuery = CACHE.getOrDefault(targetPos, 0L);
        long currentTime = System.currentTimeMillis();
        return currentTime - lastQuery < duration;
    }

    public static boolean isTickQueried(class_1937 level, class_2338 pos) {
        int tickTime = CifUtil.toIntSafe(level.method_54719().method_54749());
        TargetPos targetPos = new TargetPos(level, pos);
        long lastQuery = CACHE.getOrDefault(targetPos, 0L);
        long currentTime = System.currentTimeMillis();
        return currentTime - lastQuery < (long)tickTime;
    }

    public static void mark(class_1937 level, class_2338 pos) {
        TargetPos key = new TargetPos(level, pos);
        CACHE.put(key, System.currentTimeMillis());
    }

    public static List<class_1542> query(class_1937 level, class_2338 pos) {
        TargetPos key = new TargetPos(level, pos);
        CACHE.put(key, System.currentTimeMillis());
        return level.method_8390(class_1542.class, new class_238(pos), drop -> drop.method_5805() && !drop.method_6983().method_7960());
    }

    public static List<class_1799> queryStacks(class_1937 level, class_2338 pos) {
        return DropsCache.query(level, pos).stream().map(class_1542::method_6983).toList();
    }

    public static void remove(class_1937 level, class_2338 pos) {
        TargetPos key = new TargetPos(level, pos);
        CACHE.remove(key);
    }

    public static void clear() {
        CACHE.clear();
    }
}

