/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropDependencies
implements Iterable<Map.Entry<String, String>> {
    public static final Codec<CropDependencies> CODEC_VANILLA = Codec.STRING.xmap(s -> new CropDependencies("croparia", (String)s), keys -> keys.getKey("croparia"));
    public static final Codec<CropDependencies> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(CropDependencies::new, CropDependencies::getCandidates);
    public static final MultiCodec<CropDependencies> CODEC_ANY = CodecUtil.of(CODEC, CODEC_VANILLA);
    public static final CropDependencies EMPTY = new CropDependencies(Map.of());
    private final Map<String, String> candidates;
    private final LazySupplier<String> chosen = LazySupplier.of(() -> {
        for (Map.Entry<String, String> entry : this) {
            String modId = entry.getKey();
            if (!this.shouldLoad(modId)) continue;
            return entry.getValue();
        }
        return null;
    });

    public CropDependencies(Map<String, String> candidates) {
        this.candidates = ImmutableMap.copyOf(candidates);
    }

    public CropDependencies(String ... entries) {
        HashMap<String, String> map;
        if (entries.length % 2 == 0) {
            map = new HashMap<String, String>();
            for (int i = 0; i < entries.length; i += 2) {
                map.put(entries[i], entries[i + 1]);
            }
        } else {
            throw new IllegalArgumentException("Entries are not in pairs");
        }
        this.candidates = ImmutableMap.copyOf(map);
    }

    public boolean shouldLoad() {
        for (String modId : this.candidates.keySet()) {
            if (!this.shouldLoad(modId)) continue;
            return true;
        }
        return this.isEmpty();
    }

    protected boolean shouldLoad(String modId) {
        return Platform.isModLoaded((String)modId) && CropariaIf.CONFIG.isModValid(modId);
    }

    protected Map<String, String> getCandidates() {
        return this.candidates;
    }

    @Nullable
    public String getKey(String modId) {
        return this.candidates.get(modId);
    }

    public String getChosen() {
        return this.chosen.get();
    }

    public boolean isEmpty() {
        return this.candidates.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.candidates.entrySet().iterator();
    }

    public int size() {
        return this.candidates.size();
    }
}

