/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator.util;

import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.generator.util.DgEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface DgRegistry<E extends DgEntry>
extends Iterable<E> {
    public static final Map<class_2960, DgRegistry<?>> REGISTRY = new HashMap();
    public static final Map<DgRegistry<? extends DgEntry>, class_2960> BY_INSTANCE = new HashMap<DgRegistry<? extends DgEntry>, class_2960>();
    public static final Codec<DgRegistry<? extends DgEntry>> CODEC = class_2960.field_25139.xmap(REGISTRY::get, BY_INSTANCE::get);

    public static <E extends DgEntry, T extends DgRegistry<E>> T register(class_2960 id, T iterable) {
        REGISTRY.put(id, iterable);
        BY_INSTANCE.put(iterable, id);
        return iterable;
    }

    public static <E extends DgEntry> DgRegistry<E> ofEnum(Class<E> enumClass) {
        return new EnumRegistry<E>(enumClass);
    }

    public static <E extends DgEntry> DgRegistry<E> ofMap(Map<class_2960, E> map) {
        return new MapRegistry<E>(map);
    }

    default public Optional<E> forName(class_2960 id) {
        for (DgEntry e : this) {
            if (!e.getKey().equals((Object)id)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    default public class_2960 getId() {
        return BY_INSTANCE.get(this);
    }

    public static class EnumRegistry<E extends DgEntry>
    implements DgRegistry<E> {
        private final Map<class_2960, E> map = new LinkedHashMap<class_2960, E>();

        public EnumRegistry(Class<E> enumClass) {
            for (DgEntry e : (DgEntry[])enumClass.getEnumConstants()) {
                this.map.put(e.getKey(), e);
            }
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public Optional<E> forName(class_2960 id) {
            return Optional.ofNullable((DgEntry)this.map.get(id));
        }
    }

    public static class MapRegistry<E extends DgEntry>
    implements DgRegistry<E> {
        private final Map<class_2960, E> map;

        public MapRegistry(Map<class_2960, E> map) {
            this.map = map;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public Optional<E> forName(class_2960 name) {
            return Optional.ofNullable((DgEntry)this.map.get(name));
        }
    }
}

