/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cool.muyucloud.croparia.api.json.ListBuilder;
import cool.muyucloud.croparia.api.json.MapBuilder;
import java.util.Map;

public interface JsonBuilder {
    public static JsonObject map(Object ... entries) {
        return new MapBuilder(entries).build();
    }

    public static JsonObject map(Map<String, Object> compound) {
        return new MapBuilder(compound).build();
    }

    public static JsonArray list(Object ... list) {
        return new ListBuilder(list).build();
    }

    public static JsonElement parse(Object o) {
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return json;
        }
        if (o instanceof JsonBuilder) {
            JsonBuilder builder = (JsonBuilder)o;
            return builder.build();
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new JsonPrimitive(number);
        }
        if (o instanceof Character) {
            Character character = (Character)o;
            return new JsonPrimitive(character);
        }
        if (o instanceof String) {
            String string = (String)o;
            return new JsonPrimitive(string);
        }
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return new JsonPrimitive(bool);
        }
        throw new IllegalArgumentException("Codec is required for type: " + String.valueOf(o.getClass()));
    }

    public JsonElement build();
}

