/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.placeholder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface ListReader<E>
extends Iterable<E> {
    public static JsonArrayReader jsonArray(JsonArray array) {
        return new JsonArrayReader(array);
    }

    public static <E> ListReader<E> collection(Collection<E> list) {
        return new ListReaderImpl<E>(List.copyOf(list));
    }

    public static <E> ListReader<E> list(List<E> list) {
        return new ListReaderImpl<E>(list);
    }

    public int size();

    public E get(int var1);

    @Override
    @NotNull
    default public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ListReader.this.size();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("Index: " + this.index + ", Size: " + ListReader.this.size());
                }
                return ListReader.this.get(this.index++);
            }
        };
    }

    public static class JsonArrayReader
    implements ListReader<JsonElement> {
        private final JsonArray array;

        public JsonArrayReader(JsonArray array) {
            this.array = array;
        }

        public JsonArray get() {
            return this.array;
        }

        @Override
        public int size() {
            return this.get().size();
        }

        @Override
        public JsonElement get(int index) {
            return this.get().get(index);
        }

        @Override
        @NotNull
        public Iterator<JsonElement> iterator() {
            return this.get().iterator();
        }
    }

    public static class ListReaderImpl<E>
    implements ListReader<E> {
        private final List<E> list;

        public ListReaderImpl(List<E> list) {
            this.list = list;
        }

        public List<E> get() {
            return this.list;
        }

        @Override
        public int size() {
            return this.get().size();
        }

        @Override
        public E get(int index) {
            return this.get().get(index);
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.get().iterator();
        }
    }

    public static class ArrayReader<E>
    implements ListReader<E> {
        private final E[] array;

        public ArrayReader(E[] array) {
            this.array = array;
        }

        public E[] get() {
            return this.array;
        }

        @Override
        public int size() {
            return this.get().length;
        }

        @Override
        public E get(int index) {
            return this.get()[index];
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return Stream.of(this.get()).iterator();
        }
    }
}

