/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.core.block.Placeholder;
import cool.muyucloud.croparia.api.core.component.BlockProperties;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.TagUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BlockInput
implements class_10302 {
    public static final class_1799 STACK_UNKNOWN = class_1802.field_8542.method_7854();
    public static final class_1799 STACK_AIR = class_1802.field_8077.method_7854();
    public static final class_1799 STACK_ANY = class_1802.field_8240.method_7854();
    public static final Supplier<class_1799> STACK_PLACEHOLDER = () -> ((class_1747)CropariaItems.PLACEHOLDER_BLOCK.get()).method_7854();
    public static final BlockInput UNKNOWN = BlockInput.of(CropariaIf.of("unknown"));
    public static final BlockInput ANY = new BlockInput(null, null, BlockProperties.EMPTY);
    public static final MapCodec<BlockInput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("id").forGetter(BlockInput::getId), (App)class_6862.method_40090((class_5321)class_7924.field_41254).optionalFieldOf("tag").forGetter(BlockInput::getTag), (App)BlockProperties.CODEC.optionalFieldOf("properties", (Object)BlockProperties.EMPTY).forGetter(BlockInput::getProperties)).apply((Applicative)instance, (id, tag, properties) -> BlockInput.create(id.orElse(null), (class_6862<class_2248>)((class_6862)tag.orElse(null)), properties)));
    public static final Codec<BlockInput> CODEC_STR = Codec.STRING.xmap(BlockInput::create, BlockInput::getTaggable);
    public static final MultiCodec<BlockInput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), (T toEncode) -> {
        if (toEncode.isAny()) {
            return TestedCodec.fail(() -> "Can be encoded as empty string");
        }
        if (toEncode.getProperties().equals(BlockProperties.EMPTY)) {
            return TestedCodec.fail(() -> "Can be encoded as simple id or tag");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final class_9139<class_9129, BlockInput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final class_10302.class_10312<BlockInput> TYPE = new class_10302.class_10312(CODEC_COMP, STREAM_CODEC);
    @Nullable
    private final class_2960 id;
    @Nullable
    private final class_6862<class_2248> tag;
    @NotNull
    private final BlockProperties properties;
    private transient OnLoadSupplier<ImmutableList<class_1799>> displayStacks;
    private boolean virtualRender = false;

    public static BlockInput create(String s) {
        if (s.startsWith("#")) {
            s = s.substring(1);
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)s));
            return BlockInput.ofTag((class_6862<class_2248>)tag);
        }
        if (s.isEmpty()) {
            return ANY;
        }
        return BlockInput.of(class_2960.method_60654((String)s));
    }

    protected static BlockInput create(@Nullable class_2960 id, @Nullable class_6862<class_2248> tag, @NotNull BlockProperties properties) {
        BlockInput blockInput = new BlockInput(id, tag, properties);
        if (blockInput.isAny()) {
            return ANY;
        }
        return blockInput;
    }

    public static BlockInput ofTag(class_2960 id) {
        return BlockInput.ofTag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id));
    }

    public static BlockInput ofTag(class_2960 id, BlockProperties properties) {
        return BlockInput.ofTag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id), properties);
    }

    public static BlockInput ofTag(class_6862<class_2248> tag) {
        return BlockInput.ofTag(tag, BlockProperties.EMPTY);
    }

    public static BlockInput ofTag(class_6862<class_2248> tag, BlockProperties properties) {
        return new BlockInput(null, tag, properties);
    }

    public static BlockInput of(@NotNull class_2960 id) {
        return BlockInput.of(id, BlockProperties.EMPTY);
    }

    public static BlockInput of(@NotNull class_2960 id, BlockProperties properties) {
        return new BlockInput(id, null, properties);
    }

    public static BlockInput of(@NotNull class_2248 block) {
        return BlockInput.of(Objects.requireNonNull(block.arch$registryName()));
    }

    public static BlockInput of(@NotNull class_2680 state) {
        return new BlockInput(Objects.requireNonNull(state.method_26204().arch$registryName()), null, BlockProperties.extract(state));
    }

    protected BlockInput(@Nullable class_2960 id, @Nullable class_6862<class_2248> tag, @NotNull BlockProperties properties) {
        this.id = id;
        this.tag = tag;
        if (this.id != null && this.tag != null) {
            throw new IllegalArgumentException("id and tag cannot be set at the same time");
        }
        this.properties = properties;
        this.displayStacks = OnLoadSupplier.of(() -> {
            this.virtualRender = false;
            if (this.getId().isPresent()) {
                class_1799 displayStack = class_7923.field_41175.method_17966(this.getId().get()).map(block -> {
                    class_1799 stack = block.method_8389().method_7854();
                    if (stack.method_7960()) {
                        stack = Texts.rename(STACK_PLACEHOLDER.get(), (class_2561)Texts.translatable(block.method_63499(), new Object[0]));
                        this.virtualRender = true;
                    }
                    stack.method_57379(BlockProperties.TYPE, (Object)this.getProperties());
                    return stack;
                }).orElseGet(() -> {
                    DisplayableRecipe.LOGGER.error("Block with id '{}' not found, using placeholder", (Object)this.getId().get());
                    this.virtualRender = true;
                    return Texts.tooltip(STACK_PLACEHOLDER.get().method_7972(), Texts.literal(this.getTaggable(), new class_2583[0]));
                });
                return ImmutableList.of((Object)displayStack);
            }
            if (this.getTag().isPresent()) {
                LinkedList<class_1799> stacks = new LinkedList<class_1799>();
                for (class_6880<class_2248> holder : TagUtil.forEntries(this.getTag().get())) {
                    class_2248 block2 = (class_2248)holder.comp_349();
                    class_1799 stack = block2.method_8389().method_7854();
                    if (stack.method_7960()) {
                        stack = Texts.rename(STACK_PLACEHOLDER.get(), (class_2561)Texts.translatable(block2.method_63499(), new Object[0]));
                        this.virtualRender = true;
                    }
                    stack.method_57379(BlockProperties.TYPE, (Object)this.getProperties());
                    stacks.add(stack);
                }
                if (stacks.isEmpty()) {
                    DisplayableRecipe.LOGGER.error("Block tag '{}' is empty, using placeholder", (Object)this.getTag().get().comp_327());
                    this.virtualRender = true;
                    stacks.add(Texts.tooltip(STACK_UNKNOWN.method_7972(), Texts.literal(this.getTaggable(), new class_2583[0])));
                }
                return ImmutableList.copyOf(stacks);
            }
            if (this.getProperties().isEmpty()) {
                return ImmutableList.of((Object)STACK_ANY);
            }
            this.virtualRender = true;
            class_1799 stack = STACK_PLACEHOLDER.get();
            stack.method_57379(BlockProperties.TYPE, (Object)this.getProperties());
            return ImmutableList.of((Object)stack);
        });
    }

    public Optional<class_2960> getId() {
        return Optional.ofNullable(this.id);
    }

    public class_2960 getDisplayId() {
        return this.getTag().map(class_6862::comp_327).orElse(((class_1799)this.getDisplayStacks().getFirst()).method_7909().arch$registryName());
    }

    public Optional<class_6862<class_2248>> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @NotNull
    protected BlockProperties getProperties() {
        return this.properties;
    }

    public class_2680 getExampleState() {
        Iterable<class_6880<class_2248>> candidates;
        class_2680 state = this.getId().isPresent() ? ((class_2248)class_7923.field_41175.method_63535(this.getId().get())).method_9564() : (this.getTag().isPresent() ? ((candidates = TagUtil.forEntries(this.getTag().get())).iterator().hasNext() ? ((class_2248)candidates.iterator().next().comp_349()).method_9564() : class_2246.field_9987.method_9564()) : ((Placeholder)((Object)CropariaBlocks.PLACEHOLDER.get())).method_9564());
        return StateHolderAccess.apply(state, this.getProperties());
    }

    @NotNull
    public ImmutableList<class_1799> getDisplayStacks() {
        return this.displayStacks.get();
    }

    public void mapStacks(Function<ImmutableList<class_1799>, ImmutableList<class_1799>> mapper) {
        this.displayStacks = this.displayStacks.map(mapper);
    }

    public String getTaggable() {
        Optional<String> id = this.getId().map(class_2960::toString);
        Optional<String> tag = this.getTag().map(t -> "#" + String.valueOf(t.comp_327()));
        return id.orElse(tag.orElse(""));
    }

    public boolean isVirtualRender() {
        this.displayStacks.get();
        return this.virtualRender;
    }

    public boolean isAny() {
        return this.getId().isEmpty() && this.getTag().isEmpty() && this.getProperties().isEmpty();
    }

    public boolean isUnknown() {
        ImmutableList<class_1799> stacks = this.getDisplayStacks();
        if (stacks.size() != 1) {
            return false;
        }
        return Objects.equals(((class_1799)stacks.getFirst()).method_7909(), class_1802.field_8542) && this.isVirtualRender();
    }

    public boolean matches(@NotNull class_2248 block) {
        if (this.getId().isPresent()) {
            return Objects.equals(block.arch$registryName(), this.getId().get());
        }
        if (this.getTag().isPresent()) {
            return TagUtil.isIn(this.getTag().get(), block);
        }
        return true;
    }

    public boolean matches(@NotNull class_2680 state) {
        return this.matches(state.method_26204()) && this.getProperties().isSubsetOf(state);
    }

    @NotNull
    public <T> Stream<T> method_64739(class_10352 contextMap, class_10358<T> factory) {
        if (factory instanceof class_10358.class_10360) {
            class_10358.class_10360 forStacks = (class_10358.class_10360)factory;
            return this.getDisplayStacks().stream().map(arg_0 -> ((class_10358.class_10360)forStacks).method_64999(arg_0));
        }
        return Stream.empty();
    }

    @NotNull
    public class_10302.class_10312<? extends class_10302> method_64736() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockInput)) {
            return false;
        }
        BlockInput that = (BlockInput)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.tag, that.tag) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.properties);
    }

    static {
        STACK_UNKNOWN.method_57379(class_9334.field_49631, (Object)Texts.translatable("tooltip.croparia.unknown", new Object[0]));
        STACK_AIR.method_57379(class_9334.field_49631, (Object)Texts.translatable("tooltip.croparia.air", new Object[0]));
        STACK_ANY.method_57379(class_9334.field_49631, (Object)Texts.translatable("tooltip.croparia.any", new Object[0]));
    }
}

