/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.fabric;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.FabricFluidSpec;
import cool.muyucloud.croparia.api.resource.type.FluidSpec;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class FluidRepoProxy
extends RepoProxy<FluidSpec>
implements Storage<FluidVariant> {
    private final ArrayList<FluidView> views = new ArrayList();

    public FluidRepoProxy(Repo<FluidSpec> repo) {
        super(repo);
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext context) {
        FluidSpec fluidSpec = FabricFluidSpec.from(resource);
        if (context == null) {
            return this.accept(fluidSpec, maxAmount);
        }
        long amount = this.simAccept(fluidSpec, maxAmount);
        context.addCloseCallback((ignored, result) -> {
            if (result == TransactionContext.Result.COMMITTED) {
                this.accept(fluidSpec, amount);
            }
        });
        return amount;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext context) {
        FluidSpec fluidSpec = FabricFluidSpec.from(resource);
        if (context == null) {
            return this.consume(fluidSpec, maxAmount);
        }
        long amount = this.simConsume(fluidSpec, maxAmount);
        context.addCloseCallback((ignored, result) -> {
            if (result == TransactionContext.Result.COMMITTED) {
                this.consume(fluidSpec, amount);
            }
        });
        return amount;
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        this.views.removeIf(view -> view.i >= this.size());
        return new ItemIterator();
    }

    class ItemIterator
    implements Iterator<StorageView<FluidVariant>> {
        private int i = 0;

        ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < FluidRepoProxy.this.size();
        }

        @Override
        public StorageView<FluidVariant> next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more elements");
            }
            if (FluidRepoProxy.this.views.size() <= this.i) {
                FluidRepoProxy.this.views.add(new FluidView(this.i));
            }
            FluidView view = FluidRepoProxy.this.views.get(this.i);
            ++this.i;
            return view;
        }
    }

    class FluidView
    implements StorageView<FluidVariant> {
        private final int i;

        public FluidView(int i) {
            if (FluidRepoProxy.this.size() <= i) {
                throw new IllegalArgumentException("Index %s is out of bounds: %s".formatted(i, FluidRepoProxy.this.size()));
            }
            this.i = i;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext context) {
            FluidSpec fluidSpec = FabricFluidSpec.from(resource);
            if (context == null) {
                return FluidRepoProxy.this.consume(this.i, fluidSpec, maxAmount);
            }
            long amount = FluidRepoProxy.this.simConsume(this.i, fluidSpec, maxAmount);
            context.addCloseCallback((ignored, result) -> {
                if (result == TransactionContext.Result.COMMITTED) {
                    FluidRepoProxy.this.consume(this.i, fluidSpec, amount);
                }
            });
            return amount;
        }

        public boolean isResourceBlank() {
            return FluidRepoProxy.this.isEmpty(this.i);
        }

        public FluidVariant getResource() {
            return FabricFluidSpec.toVariant((FluidSpec)FluidRepoProxy.this.resourceFor(this.i));
        }

        public long getAmount() {
            return FluidRepoProxy.this.amountFor(this.i, (FluidSpec)FluidRepoProxy.this.resourceFor(this.i));
        }

        public long getCapacity() {
            return FluidRepoProxy.this.capacityFor(this.i, (FluidSpec)FluidRepoProxy.this.resourceFor(this.i));
        }
    }
}

