/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.fabric;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.FabricItemSpec;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class ItemRepoProxy
extends RepoProxy<ItemSpec>
implements Storage<ItemVariant> {
    private final ArrayList<ItemView> views = new ArrayList();

    public ItemRepoProxy(Repo<ItemSpec> repo) {
        super(repo);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext context) {
        ItemSpec itemSpec = FabricItemSpec.from(resource);
        if (context == null) {
            return this.accept(itemSpec, maxAmount);
        }
        long amount = this.simAccept(itemSpec, maxAmount);
        context.addCloseCallback((ignored, result) -> {
            if (result == TransactionContext.Result.COMMITTED) {
                this.accept(itemSpec, amount);
            }
        });
        return amount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext context) {
        ItemSpec itemSpec = FabricItemSpec.from(resource);
        if (context == null) {
            return this.consume(itemSpec, maxAmount);
        }
        long amount = this.simConsume(itemSpec, maxAmount);
        context.addCloseCallback((ignored, result) -> {
            if (result == TransactionContext.Result.COMMITTED) {
                this.consume(itemSpec, amount);
            }
        });
        return amount;
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        this.views.removeIf(view -> view.i >= this.size());
        return new ItemIterator();
    }

    class ItemIterator
    implements Iterator<StorageView<ItemVariant>> {
        private int i = 0;

        ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < ItemRepoProxy.this.size();
        }

        @Override
        public StorageView<ItemVariant> next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more elements");
            }
            if (ItemRepoProxy.this.views.size() <= this.i) {
                ItemRepoProxy.this.views.add(new ItemView(this.i));
            }
            ItemView view = ItemRepoProxy.this.views.get(this.i);
            ++this.i;
            return view;
        }
    }

    class ItemView
    implements StorageView<ItemVariant> {
        private final int i;

        public ItemView(int i) {
            if (ItemRepoProxy.this.size() <= i) {
                throw new IllegalArgumentException("Index %s is out of bounds: %s".formatted(i, ItemRepoProxy.this.size()));
            }
            this.i = i;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext context) {
            ItemSpec itemSpec = FabricItemSpec.from(resource);
            if (context == null) {
                return ItemRepoProxy.this.consume(this.i, itemSpec, maxAmount);
            }
            long amount = ItemRepoProxy.this.simConsume(this.i, itemSpec, maxAmount);
            context.addCloseCallback((ignored, result) -> {
                if (result == TransactionContext.Result.COMMITTED) {
                    ItemRepoProxy.this.consume(this.i, itemSpec, amount);
                }
            });
            return amount;
        }

        public boolean isResourceBlank() {
            return ItemRepoProxy.this.isEmpty(this.i);
        }

        public ItemVariant getResource() {
            return FabricItemSpec.of((ItemSpec)ItemRepoProxy.this.resourceFor(this.i));
        }

        public long getAmount() {
            return ItemRepoProxy.this.amountFor(this.i, (ItemSpec)ItemRepoProxy.this.resourceFor(this.i));
        }

        public long getCapacity() {
            return ItemRepoProxy.this.capacityFor(this.i, (ItemSpec)ItemRepoProxy.this.resourceFor(this.i));
        }
    }
}

