/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Consumer;

public class FileUtil {
    public static void write(File file, String content, boolean override) throws IOException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Failed to establish parent directory for " + String.valueOf(file));
        }
        if (!file.isFile() || override) {
            Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
        }
    }

    public static void transfer(InputStream stream, File output, boolean override) throws IOException {
        File parent = output.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Failed to establish parent directory for " + String.valueOf(output));
        }
        if (!output.isFile() || override) {
            try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
                stream.transferTo(outputStream);
            }
        }
    }

    public static void forFilesIn(File path, Consumer<File> consumer) throws IOException {
        if (!path.isDirectory() && !path.mkdirs()) {
            throw new IOException("Failed to establish directory " + String.valueOf(path));
        }
        File[] files = path.listFiles();
        if (files == null) {
            throw new IOException("Failed to list directory " + String.valueOf(path));
        }
        for (File file : files) {
            if (file.isFile()) {
                consumer.accept(file);
            }
            if (!file.isDirectory()) continue;
            FileUtil.forFilesIn(file, consumer);
        }
    }

    public static void deleteUnder(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            if (children == null) {
                throw new IOException("Failed to list directory " + String.valueOf(dir));
            }
            for (File child : children) {
                FileUtil.deleteDir(child);
            }
        }
    }

    public static void deleteDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            if (children == null) {
                throw new IOException("Failed to list directory " + String.valueOf(dir));
            }
            for (File child : children) {
                FileUtil.deleteDir(child);
            }
        }
        Files.delete(dir.toPath());
    }
}

