/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.item.Croparia;
import cool.muyucloud.croparia.api.crop.util.Color;
import cool.muyucloud.croparia.api.crop.util.CropDependencies;
import cool.muyucloud.croparia.api.crop.util.Material;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class CreateCommand {
    private static final LiteralArgumentBuilder<class_2168> CREATE = class_2170.method_9247((String)"create");
    private static final RequiredArgumentBuilder<class_2168, String> TYPE = RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<class_2168, String> COLOR = RequiredArgumentBuilder.argument((String)"color", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<class_2168, String> NAME = RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word());
    private static final LiteralArgumentBuilder<class_2168> REPLACE = LiteralArgumentBuilder.literal((String)"replace");

    public static LiteralArgumentBuilder<class_2168> build() {
        return CREATE;
    }

    public static int create(class_1657 player, @Nullable class_2960 id, String type, String rawColor, SuccessMessenger success, FailureMessenger failure, boolean client, boolean forced) {
        Color color;
        class_1799 material = player.method_6047();
        if (material.method_7960()) {
            failure.send((class_2561)Texts.translatable("commands.croparia.create.no_material", new Object[0]));
            return -1;
        }
        class_1792 rawCroparia = player.method_6079().method_7909();
        id = id == null ? CropariaIf.of(Objects.requireNonNull(material.method_7909().arch$registryName()).method_12836()) : id;
        try {
            color = new Color(rawColor);
        }
        catch (NumberFormatException e) {
            failure.send((class_2561)Texts.translatable("commands.croparia.create.invalid_color", rawColor));
            return -1;
        }
        if (!forced && DgRegistries.CROPS.exists(id)) {
            class_5250 crop = Texts.literal(id.toString(), new class_2583[0]);
            crop.method_27696(Texts.runCommand(CommonCommandRoot.commandRoot(client), "crop", id.toString())).method_27696(Texts.inlineMouseBehavior());
            class_5250 rename = Texts.translatable("commands.croparia.create.duplicated.rename", new Object[0]).method_27696(Texts.suggestCommand(CommonCommandRoot.commandRoot(client), "create", rawColor, type, String.valueOf(id) + "_")).method_27696(Texts.inlineMouseBehavior());
            class_5250 replace = Texts.translatable("commands.croparia.create.duplicated.replace", new Object[0]).method_27696(Texts.suggestCommand(CommonCommandRoot.commandRoot(client), "create", rawColor, type, id.toString(), "replace")).method_27696(Texts.inlineMouseBehavior());
            class_5250 duplication = Texts.translatable("commands.croparia.create.duplicated", crop, rename, replace);
            failure.send((class_2561)duplication);
            return -1;
        }
        if (rawCroparia instanceof Croparia) {
            Croparia croparia = (Croparia)rawCroparia;
            Crop crop = CreateCommand.buildCrop(id, material, color, croparia.getTier(), type);
            Path result = DgRegistries.CROPS.dumpCrop(crop);
            class_5250 resultComponent = Texts.literal(result.toString(), new class_2583[0]);
            if (client) {
                resultComponent.method_27696(Texts.openFile(result.toString())).method_27696(Texts.inlineMouseBehavior());
            }
            success.send((class_2561)Texts.translatable("commands.croparia.create.success", resultComponent), true);
            return croparia.getTier();
        }
        failure.send((class_2561)Texts.translatable("commands.croparia.create.invalid_croparia", new Object[0]));
        return -1;
    }

    public static Crop buildCrop(class_2960 id, class_1799 material, Color color, int tier, String type) {
        return new Crop(id, new Material(material), color, tier, type, null, new CropDependencies(id.method_12836(), material.method_7909().method_7876()));
    }

    static {
        CREATE.requires(s -> s.method_9259(2));
        COLOR.executes(context -> CreateCommand.create((class_1657)((class_2168)context.getSource()).method_9207(), null, Crop.DEFAULT_TYPE, StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()), false, false));
        TYPE.suggests((context, builder) -> {
            for (String type : Crop.PRESET_TYPES) {
                builder.suggest(type);
            }
            return builder.buildFuture();
        }).executes(context -> CreateCommand.create((class_1657)((class_2168)context.getSource()).method_9207(), null, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()), false, false));
        NAME.executes(context -> CreateCommand.create((class_1657)((class_2168)context.getSource()).method_9207(), class_2232.method_9443((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()), false, false));
        REPLACE.executes(context -> CreateCommand.create((class_1657)((class_2168)context.getSource()).method_9207(), class_2232.method_9443((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()), false, true));
        NAME.then(REPLACE);
        TYPE.then(NAME);
        COLOR.then(TYPE);
        CREATE.then(COLOR);
    }
}

