/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.DgRegistries;
import cool.muyucloud.croparia.util.text.FailureMessenger;
import cool.muyucloud.croparia.util.text.SuccessMessenger;
import cool.muyucloud.croparia.util.text.Texts;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class DumpCommand {
    private static final LiteralArgumentBuilder<class_2168> DUMP = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires(s -> s.method_9259(2))).executes(context -> DumpCommand.dumpAll((msg, broadcast) -> Texts.success((class_2168)context.getSource(), msg, broadcast), false))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> Crops.cropSuggestions(builder)).executes(context -> {
        class_2960 id = class_2232.method_9443((CommandContext)context, (String)"id");
        return DumpCommand.dump(id, Texts.success((class_2168)context.getSource()), Texts.failure((class_2168)context.getSource()), false);
    }));

    public static int dumpAll(SuccessMessenger success, boolean openFile) {
        int size = DgRegistries.CROPS.size();
        class_5250 component = Texts.translatable("commands.croparia.dump.perform", size);
        if (openFile) {
            component.method_27696(Texts.openFile(CropariaIf.CONFIG.getFilePath().resolve("crops").toString()));
            component.method_27696(Texts.blockMouseBehavior());
        }
        success.send((class_2561)component, true);
        DgRegistries.CROPS.dumpCrops();
        return size;
    }

    public static int dump(class_2960 id, SuccessMessenger success, FailureMessenger failure, boolean openFile) {
        Optional<Crop> optional = DgRegistries.CROPS.forName(id);
        if (optional.isEmpty()) {
            class_5250 component = Texts.translatable("commands.croparia.dump.singular.absent", id);
            failure.send((class_2561)component);
            return 0;
        }
        Path dumped = DgRegistries.CROPS.dumpCrop(optional.get());
        if (dumped != null) {
            class_5250 nameComponent = Texts.literal(id.toString(), new class_2583[0]);
            if (openFile) {
                nameComponent.method_27696(Texts.openFile(dumped.toString()));
            }
            class_5250 component = Texts.translatable("commands.croparia.dump.singular", id);
            success.send((class_2561)component, true);
            return 1;
        }
        failure.send((class_2561)Texts.translatable("commands.croparia.dump.singular.fail", id));
        return 0;
    }

    public static LiteralArgumentBuilder<class_2168> build() {
        return DUMP;
    }
}

