/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TargetPos
implements class_9299 {
    public static final MapCodec<TargetPos> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("dim").forGetter(TargetPos::getDim), (App)class_2338.field_25064.fieldOf("pos").forGetter(TargetPos::getPos)).apply((Applicative)instance, TargetPos::new));
    public static final class_9331<TargetPos> TYPE = class_9331.method_57873().method_57881(CODEC.codec()).method_57880();
    @NotNull
    private final transient class_5250 dimName;
    @NotNull
    private final transient class_5321<class_1937> dimKey;
    @NotNull
    private final class_2338 pos;
    private final transient class_5250 tooltip;

    public TargetPos(@NotNull class_1297 entity) {
        this(entity.method_37908(), entity.method_24515());
    }

    public TargetPos(@NotNull class_1937 level, @NotNull class_2338 pos) {
        this((class_5321<class_1937>)level.method_27983(), pos);
    }

    public TargetPos(@NotNull class_5321<class_1937> dim, @NotNull class_2338 pos) {
        this.pos = pos;
        this.dimKey = dim;
        this.dimName = Texts.translatable("dimension.%s.%s".formatted(dim.method_29177().method_12836(), dim.method_29177().method_12832()), new Object[0]);
        this.tooltip = Texts.translatable("tooltip.croparia.bounded_position", this.getDimName(), this.getPos().method_10263(), this.getPos().method_10264(), this.getPos().method_10260());
    }

    public TargetPos(@NotNull class_2960 dim, @NotNull class_2338 pos) {
        this.pos = pos;
        this.dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dim);
        this.dimName = Texts.translatable("dimension.%s.%s".formatted(dim.method_12836(), dim.method_12832()), new Object[0]);
        this.tooltip = Texts.translatable("tooltip.croparia.bounded_position", this.getDimName(), this.getPos().method_10263(), this.getPos().method_10264(), this.getPos().method_10260());
    }

    @NotNull
    public class_2960 getDim() {
        return this.dimKey.method_29177();
    }

    @NotNull
    public class_5250 getDimName() {
        return this.dimName;
    }

    @NotNull
    public class_5321<class_1937> getDimKey() {
        return this.dimKey;
    }

    public Optional<class_3218> getLevel(@NotNull MinecraftServer server) {
        return Optional.ofNullable(server.method_3847(this.getDimKey()));
    }

    @NotNull
    public class_2338 getPos() {
        return this.pos;
    }

    public class_5250 getTooltip() {
        return this.tooltip;
    }

    public void method_57409(class_1792.class_9635 tooltipContext, @NotNull Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        consumer.accept((class_2561)this.getTooltip());
    }

    public void teleport(@NotNull class_1297 entity, @NotNull MinecraftServer server) {
        this.getLevel(server).ifPresent(level -> entity.method_48105(level, (double)this.getPos().method_10263(), (double)this.getPos().method_10264(), (double)this.getPos().method_10260(), class_2709.field_40711, 0.0f, 0.0f, true));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetPos)) {
            return false;
        }
        TargetPos targetPos = (TargetPos)o;
        return Objects.equals(this.dimKey, targetPos.dimKey) && Objects.equals(this.pos, targetPos.pos);
    }

    public int hashCode() {
        return Objects.hash(this.dimKey, this.pos);
    }
}

