/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.item;

import com.google.common.collect.ImmutableList;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.util.RecipeWizardGenerator;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import cool.muyucloud.croparia.api.generator.util.JarJarEntry;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.util.FileUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class RecipeWizard
extends class_1792 {
    public static final class_2960 PACK_ID = CropariaIf.of("recipe_wizard");
    public static final OnLoadSupplier<Collection<RecipeWizardGenerator>> GENERATORS = OnLoadSupplier.of(() -> {
        for (JarJarEntry entry : PackHandler.getBuiltinGenerators(PACK_ID)) {
            String name = entry.getEntry().getName();
            String prefix = "data-generators/%s/%s/".formatted(PACK_ID.method_12836(), PACK_ID.method_12832());
            Path target = CropariaIf.CONFIG.getFilePath().resolve("recipe_wizard/generators").resolve(name.substring(prefix.length()));
            try {
                entry.forInputStream(inputStream -> {
                    try (FileOutputStream outputStream = new FileOutputStream(target.toFile());){
                        inputStream.transferTo(outputStream);
                        outputStream.flush();
                    }
                });
            }
            catch (IOException e) {
                CropariaIf.LOGGER.error("Failed to move built-in recipe wizard template from %s to %s".formatted(name, target), (Throwable)e);
            }
        }
        ArrayList generators = new ArrayList();
        try {
            FileUtil.forFilesIn(CropariaIf.CONFIG.getFilePath().resolve("recipe_wizard/generators").toFile(), file -> RecipeWizardGenerator.read(file).ifPresent(generator -> {
                if (generator.isEnabled()) {
                    generators.add(generator);
                }
            }));
        }
        catch (IOException e) {
            CropariaIf.LOGGER.error("Failed to read recipe wizard generators", (Throwable)e);
        }
        return ImmutableList.copyOf(generators);
    });
    public static final Map<BlockInput, Function<class_1838, class_1269>> OPERATIONS = new HashMap<BlockInput, Function<class_1838, class_1269>>();

    public RecipeWizard(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (player == null || context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        if (player.method_18276()) {
            for (Map.Entry<BlockInput, Function<class_1838, class_1269>> entry : OPERATIONS.entrySet()) {
                class_1269 result;
                if (!entry.getKey().matches(level.method_8320(context.method_8037())) || (result = entry.getValue().apply(context)) instanceof class_1269.class_9859) continue;
                return result;
            }
        }
        if (!level.method_8608() || !player.method_7340()) {
            return class_1269.field_5811;
        }
        class_2680 target = context.method_8045().method_8320(context.method_8037());
        for (RecipeWizardGenerator generator : GENERATORS.get()) {
            if (!generator.matches(target)) continue;
            generator.handle(context);
            player.method_7357().method_62835(context.method_8041(), 5);
            return class_1269.field_5812;
        }
        Texts.overlay(player, (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.error.no_match", new Object[0]));
        return class_1269.field_5811;
    }

    static {
        OPERATIONS.put(BlockInput.ofTag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)"croparia:ritual_stands"))), context -> {
            class_2680 state = context.method_8045().method_8320(context.method_8037());
            return RitualStructure.TYPED_SERIALIZER.find(new RitualStructureContainer(state), context.method_8045()).map(structure -> {
                structure.tryBuild(context.method_8045(), context.method_8037());
                return class_1269.field_5812;
            }).orElse((class_1269)class_1269.field_5811);
        });
        OPERATIONS.put(BlockInput.of(CropariaBlocks.INFUSOR.getId()), context -> {
            class_2680 state = context.method_8045().method_8320(context.method_8037());
            int i = (Infusor.ELEMENT.method_64221((Enum)((Element)state.method_11654(Infusor.ELEMENT))) + 1) % Infusor.ELEMENT.method_11898().size();
            Element element = (Element)Infusor.ELEMENT.method_11898().get(i);
            context.method_8045().method_8501(context.method_8037(), (class_2680)state.method_11657(Infusor.ELEMENT, (Comparable)element));
            return class_1269.field_5812;
        });
    }
}

