/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.container.InfusorContainer;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.ItemInput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10302;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfusorRecipe
implements DisplayableRecipe<InfusorContainer> {
    public static final TypedSerializer<InfusorRecipe> TYPED_SERIALIZER = new TypedSerializer<InfusorRecipe>(CropariaIf.of("infusor"), InfusorRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)ElementAccess.CODEC.fieldOf("element").forGetter(InfusorRecipe::getElement), (App)ItemInput.CODEC.fieldOf("ingredient").forGetter(InfusorRecipe::getIngredient), (App)ItemOutput.CODEC.fieldOf("result").forGetter(InfusorRecipe::getResult)).apply((Applicative)instance, InfusorRecipe::new)), TypedSerializer.JEI, Mappable.of(CropariaItems.INFUSOR, class_1792::method_7854));
    public static final TypedSerializer<InfusorRecipe> OLD_TYPED_SERIALIZER = new TypedSerializer<InfusorRecipe>(CropariaIf.of("infusor_type"), InfusorRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)ElementAccess.CODEC.fieldOf("element").forGetter(InfusorRecipe::getElement), (App)ItemInput.CODEC.fieldOf("input").forGetter(InfusorRecipe::getIngredient), (App)ItemOutput.CODEC.fieldOf("output").forGetter(InfusorRecipe::getResult), (App)Codec.INT.fieldOf("count").forGetter(recipe -> Math.toIntExact(recipe.getResult().getAmount()))).apply((Applicative)instance, (element, input, output, count) -> new InfusorRecipe((Element)element, (ItemInput)input, new ItemOutput(output.getId(), output.getComponentsPatch(), count.intValue())))), TypedSerializer.JEI, Mappable.of(CropariaItems.INFUSOR, class_1792::method_7854));
    protected final Element element;
    protected final ItemInput ingredient;
    protected final ItemOutput result;

    public InfusorRecipe(@NotNull Element element, @NotNull ItemInput ingredient, @NotNull ItemOutput result) {
        if (element == Element.EMPTY) {
            throw new IllegalArgumentException("Element cannot be EMPTY");
        }
        this.element = element;
        this.ingredient = ingredient;
        this.result = result;
        this.ingredient.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.ITEM_DROP_TOOLTIP));
            return stacks;
        });
    }

    public ItemInput getIngredient() {
        return this.ingredient;
    }

    public ItemOutput getResult() {
        return this.result;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean matches(InfusorContainer container) {
        class_1799 input = container.method_59984(0);
        return this.getIngredient().matches(input) && container.getElement() == this.getElement();
    }

    @NotNull
    public class_1799 assemble(@NotNull InfusorContainer container) {
        if (this.matches(container)) {
            class_1799 input = container.method_59984(0);
            input.method_7934((int)this.getIngredient().getAmount());
            return this.getResult().createStack();
        }
        return class_1799.field_8037;
    }

    public class_1799 getPotion() {
        return Texts.tooltip(ElementalPotion.fromElement(this.getElement()).orElseThrow().method_7854(), Constants.ELEM_INFUSE_TOOLTIP);
    }

    @Override
    @NotNull
    public List<List<class_1799>> getInputs() {
        return List.of(this.getIngredient().getDisplayStacks(), List.of(this.getPotion()));
    }

    @Override
    @NotNull
    public List<List<class_1799>> getOutputs() {
        return List.of(List.of(this.getResult().getDisplayStack()));
    }

    public boolean matches(@NotNull InfusorContainer container, @Nullable class_1937 level) {
        return this.matches(container);
    }

    @NotNull
    public class_1799 assemble(InfusorContainer recipeInput, class_7225.class_7874 provider) {
        return this.assemble(recipeInput);
    }

    @NotNull
    public ItemOutput result() {
        return this.getResult();
    }

    @NotNull
    public class_10302.class_10307 craftingStation() {
        return new class_10302.class_10307(((class_1747)CropariaItems.INFUSOR.get()).method_7854());
    }

    @Override
    public TypedSerializer<? extends InfusorRecipe> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InfusorRecipe)) {
            return false;
        }
        InfusorRecipe that = (InfusorRecipe)o;
        return Objects.equals(this.element, that.element) && Objects.equals(this.ingredient, that.ingredient) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.ingredient, this.result);
    }
}

