/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.container.SoakContainer;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.BlockOutput;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10302;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class SoakRecipe
implements DisplayableRecipe<SoakContainer> {
    public static final TypedSerializer<SoakRecipe> TYPED_SERIALIZER = new TypedSerializer<SoakRecipe>(CropariaIf.of("soak"), SoakRecipe.class, RecordCodecBuilder.mapCodec(instance -> instance.group((App)ElementAccess.CODEC.fieldOf("element").forGetter(SoakRecipe::getElement), (App)Codec.FLOAT.fieldOf("probability").forGetter(SoakRecipe::getProbability), (App)BlockInput.CODEC.fieldOf("input").forGetter(SoakRecipe::getInput), (App)BlockOutput.CODEC.fieldOf("output").forGetter(SoakRecipe::getOutput)).apply((Applicative)instance, SoakRecipe::new)), TypedSerializer.JEI, Mappable.of(CropariaItems.ELEMENTAL_STONE, class_1792::method_7854));
    private final Element element;
    private final float probability;
    private final BlockInput input;
    private final BlockOutput output;

    public SoakRecipe(Element element, float probability, BlockInput input, BlockOutput output) {
        if (element == Element.EMPTY) {
            throw new IllegalArgumentException("Element cannot be EMPTY");
        }
        this.element = element;
        this.probability = probability;
        this.input = input;
        this.output = output;
        this.input.mapStacks(stacks -> {
            stacks.forEach(stack -> Texts.tooltip(stack, Constants.SOAK_BLOCK_INPUT));
            return stacks;
        });
    }

    public Element getElement() {
        return this.element;
    }

    public class_1799 getPotion() {
        return Texts.tooltip(((ElementalPotion)this.getElement().getPotion().get()).method_7854(), Constants.ELEM_INFUSE_TOOLTIP);
    }

    public float getProbability() {
        return this.probability;
    }

    public BlockInput getInput() {
        return this.input;
    }

    public BlockOutput getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<List<class_1799>> getInputs() {
        return List.of(this.getInput().getDisplayStacks(), List.of(this.getPotion()));
    }

    @Override
    @NotNull
    public List<List<class_1799>> getOutputs() {
        return List.of(List.of(this.getOutput().getDisplayStack()));
    }

    public boolean matches(SoakContainer input, class_1937 level) {
        return this.getInput().matches(input.getState()) && this.getElement() == input.getElement() && input.getRandom() < this.getProbability();
    }

    @Override
    public TypedSerializer<SoakRecipe> getTypedSerializer() {
        return TYPED_SERIALIZER;
    }

    @Deprecated
    @NotNull
    public class_1799 assemble(SoakContainer recipeInput, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_10302 comp_3258() {
        return this.getOutput();
    }

    @Override
    @NotNull
    public class_10302 comp_3259() {
        return new class_10302.class_10307((class_1799)this.getTypedSerializer().getStations().getFirst().get());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SoakRecipe)) {
            return false;
        }
        SoakRecipe that = (SoakRecipe)o;
        return Float.compare(this.probability, that.probability) == 0 && Objects.equals(this.element, that.element) && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.element, Float.valueOf(this.probability), this.input, this.output);
    }
}

