/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.access.AbstractFurnaceBlockEntityAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.block.RitualStand;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.util.ReplaceException;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.generator.util.DgReader;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.PlaceholderException;
import cool.muyucloud.croparia.api.placeholder.Template;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.recipe.entry.BlockOutput;
import cool.muyucloud.croparia.api.recipe.entry.ItemOutput;
import cool.muyucloud.croparia.registry.Recipes;
import cool.muyucloud.croparia.util.Dependencies;
import cool.muyucloud.croparia.util.FileUtil;
import cool.muyucloud.croparia.util.text.Texts;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5575;

public class RecipeWizardGenerator {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    protected static final Map<class_2960, ArrayList<Placeholder<class_1838>>> EXTENSIONS = new HashMap<class_2960, ArrayList<Placeholder<class_1838>>>();
    public static final Placeholder<class_1838> TIMESTAMP = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^datetime$"), TypeMapper.of(context -> LocalDateTime.now().format(FORMATTER)));
    public static final Placeholder<class_1838> MAIN_HAND = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^main_hand$"), TypeMapper.of(context -> {
        class_1799 stack = Objects.requireNonNull(context.method_8036()).method_5998(class_1268.field_5808);
        if (stack.method_7960()) {
            Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.main_hand", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(stack);
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<class_1838> OFF_HAND = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^off_hand$"), TypeMapper.of(context -> {
        class_1799 stack = Objects.requireNonNull(context.method_8036()).method_5998(class_1268.field_5810);
        if (stack.method_7960()) {
            Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.off_hand", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(stack);
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<class_1838> ITEM = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^item$"), TypeMapper.of(context -> {
        List entities = context.method_8045().method_18023(class_5575.method_31795(class_1542.class), class_238.method_54784((class_2338)context.method_8037(), (class_2338)context.method_8037().method_10084()), item -> !item.method_6983().method_7960());
        if (entities.isEmpty()) {
            assert (context.method_8036() != null);
            Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.target_item", new Object[0]));
            throw new ReplaceException();
        }
        return ItemOutput.of(((class_1542)entities.getFirst()).method_6983());
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<class_1838> BLOCK = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^block$"), TypeMapper.of(context -> {
        class_1937 level = context.method_8045();
        class_2680 block = level.method_8320(context.method_8037());
        if (block.method_26215()) {
            assert (context.method_8036() != null);
            Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.block", new Object[0]));
            throw new ReplaceException();
        }
        return BlockOutput.of(block);
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<class_1838> NEIGHBOR = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^neighbor$"), TypeMapper.of(context -> {
        class_1937 level = context.method_8045();
        for (class_2350 direction : class_2350.values()) {
            class_2680 state;
            if (direction == class_2350.field_11036 || direction == class_2350.field_11033 || (state = level.method_8320(context.method_8037().method_10081(direction.method_62675()))).method_26215()) continue;
            return BlockOutput.of(state);
        }
        assert (context.method_8036() != null);
        Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.neighbor", new Object[0]));
        throw new ReplaceException();
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<class_1838> BELOW = RecipeWizardGenerator.register(class_2960.method_60654((String)"default"), Pattern.compile("^below$"), TypeMapper.of(context -> {
        class_1937 level = context.method_8045();
        class_2680 state = level.method_8320(context.method_8037().method_10074());
        if (state.method_26215()) {
            assert (context.method_8036() != null);
            Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.default.missing.block", new Object[0]));
            throw new ReplaceException();
        }
        return BlockOutput.of(state);
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<class_1838> INFUSOR_ELEMENT = RecipeWizardGenerator.register(CropariaIf.of("infusor"), Pattern.compile("^infusor_element$"), TypeMapper.of(context -> {
        Element element;
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        if (state.method_26204() instanceof Infusor && (element = (Element)state.method_11654(Infusor.ELEMENT)) != Element.EMPTY) {
            return element.method_15434();
        }
        assert (context.method_8036() != null);
        Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.infusor.missing.element", new Object[0]));
        throw new ReplaceException();
    }));
    public static final Placeholder<class_1838> RITUAL_INPUT = RecipeWizardGenerator.register(CropariaIf.of("ritual"), Pattern.compile("^ritual_input$"), TypeMapper.of(context -> {
        RitualStructureContainer container;
        Optional<RitualStructure> structure;
        Optional input;
        class_2338 pos;
        class_1937 level = context.method_8045();
        class_2680 state = level.method_8320(pos = context.method_8037());
        if (state.method_26204() instanceof RitualStand && (input = (structure = Recipes.RITUAL_STRUCTURE.find(container = new RitualStructureContainer(state), level)).flatMap(s -> s.validate(pos, level).getStates().stream().filter(candidate -> !candidate.method_26215()).findFirst())).isPresent()) {
            return BlockOutput.of((class_2680)input.get());
        }
        assert (context.method_8036() != null);
        Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.ritual.missing.block", new Object[0]));
        throw new ReplaceException();
    }), Placeholder.BLOCK_OUTPUT);
    public static final Placeholder<class_1838> SOAK_ELEMENT = RecipeWizardGenerator.register(CropariaIf.of("soak"), Pattern.compile("^soak_element$"), TypeMapper.of(context -> {
        class_2680 state = context.method_8045().method_8320(context.method_8037().method_10084());
        class_2248 patt0$temp = state.method_26204();
        if (patt0$temp instanceof Infusor) {
            Infusor infusor = (Infusor)patt0$temp;
            Element element = (Element)state.method_11654(Infusor.ELEMENT);
            return element.method_15434();
        }
        assert (context.method_8036() != null);
        Texts.overlay(context.method_8036(), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.soak.missing.element", new Object[0]));
        throw new ReplaceException();
    }));
    public static final Placeholder<class_1838> FURNACE_INPUT = RecipeWizardGenerator.register(class_2960.method_60654((String)"furnace"), Pattern.compile("^furnace_input$"), TypeMapper.of(context -> {
        class_2586 be = context.method_8045().method_8321(context.method_8037());
        if (be instanceof class_2609) {
            class_2609 furnace = (class_2609)be;
            class_1799 stack = furnace.method_5438(0);
            if (!stack.method_7960()) {
                return ItemOutput.of(stack);
            }
            Texts.overlay(Objects.requireNonNull(context.method_8036()), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_input", new Object[0]));
        } else {
            Texts.overlay(Objects.requireNonNull(context.method_8036()), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_furnace", new Object[0]));
        }
        throw new ReplaceException();
    }), Placeholder.ITEM_OUTPUT);
    public static final Placeholder<class_1838> FURNACE_TIME = RecipeWizardGenerator.register(class_2960.method_60654((String)"furnace"), Pattern.compile("^furnace_time$"), TypeMapper.of(context -> {
        class_2586 be = context.method_8045().method_8321(context.method_8037());
        if (!(be instanceof class_2609)) {
            Texts.overlay(Objects.requireNonNull(context.method_8036()), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_furnace", new Object[0]));
            throw new ReplaceException();
        }
        class_2609 furnace = (class_2609)be;
        class_1799 input = furnace.method_5438(0);
        if (input.method_7960()) {
            Texts.overlay(Objects.requireNonNull(context.method_8036()), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_input", new Object[0]));
            throw new ReplaceException();
        }
        class_1799 fuel = furnace.method_5438(1);
        if (fuel.method_7960()) {
            Texts.overlay(Objects.requireNonNull(context.method_8036()), (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.furnace.no_fuel", new Object[0]));
            throw new ReplaceException();
        }
        return String.valueOf(((AbstractFurnaceBlockEntityAccess)furnace).cif$getBurnDuration(context.method_8045(), fuel) * fuel.method_7947());
    }));
    public static final MapCodec<RecipeWizardGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(RecipeWizardGenerator::isEnabled), (App)Dependencies.CODEC.optionalFieldOf("dependencies", (Object)Dependencies.EMPTY).forGetter(RecipeWizardGenerator::getDependencies), (App)BlockInput.CODEC.fieldOf("block").forGetter(RecipeWizardGenerator::getBlock), (App)Template.CODEC.fieldOf("path").forGetter(RecipeWizardGenerator::getPath), (App)CodecUtil.listOf(class_2960.field_25139).optionalFieldOf("extensions", List.of()).forGetter(RecipeWizardGenerator::getExtensions), (App)Template.CODEC.fieldOf("template").forGetter(RecipeWizardGenerator::getTemplate)).apply((Applicative)instance, RecipeWizardGenerator::new));
    private final boolean enabled;
    private final Dependencies dependencies;
    private final BlockInput block;
    private final Template path;
    private final List<class_2960> extensions;
    private final Template template;
    private final transient Placeholder<class_1838> placeholder;

    public static Optional<RecipeWizardGenerator> read(File file) {
        try {
            JsonObject json = DgReader.read(file);
            if (!(json.isJsonObject() && !json.getAsJsonObject().has("dependencies") || ((Boolean)CodecUtil.decodeJson(json.getAsJsonObject().get("dependencies"), Dependencies.CODEC).mapOrElse(Dependencies::available, e -> {
                CropariaIf.LOGGER.error("Failed to analyze dependencies of recipe wizard file %s".formatted(file));
                CropariaIf.LOGGER.error(e.message());
                return false;
            })).booleanValue())) {
                CropariaIf.LOGGER.warn("Skipped loading recipe wizard file %s due to missing or bad dependencies".formatted(file));
                return Optional.empty();
            }
            return (Optional)CodecUtil.decodeJson((JsonElement)json, CODEC).mapOrElse(Optional::of, error -> {
                CropariaIf.LOGGER.error("Failed to compile recipe wizard file %s".formatted(file), error);
                return Optional.empty();
            });
        }
        catch (JsonParseException | IOException e2) {
            CropariaIf.LOGGER.error("Failed to read recipe wizard file %s".formatted(file), e2);
            return Optional.empty();
        }
    }

    public static Placeholder<class_1838> register(class_2960 id, Placeholder<class_1838> placeholder) {
        ArrayList list = EXTENSIONS.computeIfAbsent(id, k -> new ArrayList());
        list.add(placeholder);
        list.trimToSize();
        return placeholder;
    }

    public static Placeholder<class_1838> register(class_2960 id, Pattern key, TypeMapper<class_1838, String> function) {
        return RecipeWizardGenerator.register(id, key, function, Placeholder.STRING);
    }

    public static <T> Placeholder<class_1838> register(class_2960 id, Pattern key, TypeMapper<class_1838, T> function, Placeholder<T> parser) {
        return RecipeWizardGenerator.register(id, Placeholder.build(builder -> builder.then(key, function, parser)));
    }

    protected static Collection<Placeholder<class_1838>> getExtensions(class_2960 id) {
        return EXTENSIONS.getOrDefault(id, new ArrayList());
    }

    public RecipeWizardGenerator(boolean enabled, Dependencies dependencies, BlockInput block, Template path, List<class_2960> extensions, Template template) {
        ImmutableList immutable;
        this.enabled = enabled;
        this.dependencies = dependencies;
        this.block = block;
        this.path = path;
        this.extensions = extensions instanceof ImmutableList ? (immutable = (ImmutableList)extensions) : ImmutableList.copyOf(extensions);
        this.template = template;
        this.placeholder = Placeholder.build(builder -> {
            Collection<Placeholder<class_1838>> defaults = RecipeWizardGenerator.getExtensions(class_2960.method_60654((String)"default"));
            for (Placeholder<class_1838> p : defaults) {
                builder.overwrite(p, TypeMapper.identity());
            }
            for (class_2960 id : this.getExtensions()) {
                Collection<Placeholder<class_1838>> extension = RecipeWizardGenerator.getExtensions(id);
                for (Placeholder<class_1838> p : extension) {
                    builder.overwrite(p, TypeMapper.identity());
                }
            }
            return builder;
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockInput getBlock() {
        return this.block;
    }

    public Template getPath() {
        return this.path;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public List<class_2960> getExtensions() {
        return this.extensions;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Placeholder<class_1838> getPlaceholder() {
        return this.placeholder;
    }

    public boolean matches(class_2680 state) {
        return this.getBlock().matches(state);
    }

    public void handle(class_1838 context) {
        class_1657 player = Objects.requireNonNull(context.method_8036());
        if (this.isEnabled()) {
            try {
                String path = this.getPath().parse(context, this.getPlaceholder());
                String template = this.getTemplate().parse(context, this.getPlaceholder());
                Path result = CropariaIf.CONFIG.getRecipeWizard().resolve(path);
                FileUtil.write(result.toFile(), template, true);
                String s = result.toString();
                class_5250 c = Texts.literal(s, new class_2583[0]).method_27696(Texts.openFile(s)).method_27696(Texts.inlineMouseBehavior());
                Texts.chat(player, (class_2561)Texts.translatable("chat.croparia.recipe_wizard.success", c));
            }
            catch (ReplaceException path) {
            }
            catch (PlaceholderException | IOException e) {
                Texts.chat(player, (class_2561)Texts.translatable("overlay.croparia.recipe_wizard.failed", new Object[0]).method_27692(class_124.field_1061));
                CropariaIf.LOGGER.error("Failed to generate recipe", (Throwable)e);
            }
        }
    }
}

