/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import cool.muyucloud.croparia.util.TagUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;

public class Material {
    public static final Codec<Material> CODEC_STR = Codec.STRING.xmap(Material::new, Material::getName);
    public static final MapCodec<Material> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Material::getName), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(Material::getComponents), (App)Codec.INT.optionalFieldOf("count", (Object)2).forGetter(Material::getCount)).apply((Applicative)instance, Material::new));
    public static final MultiCodec<Material> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toDecode -> toDecode.components.equals((Object)class_9326.field_49588) ? TestedCodec.fail(() -> "No components, proceed to string codec") : TestedCodec.success()), CODEC_STR);
    public static final Placeholder<Material> PLACEHOLDER = Placeholder.build(node -> node.self(TypeMapper.identity(), CODEC).then(PatternKey.literal("stack"), TypeMapper.of(Material::getStack), class_1799.field_24671).then(PatternKey.literal("type"), TypeMapper.of(material -> material.isTag() ? "tag" : "item"), Placeholder.STRING).then(PatternKey.literal("name"), TypeMapper.of(Material::getName), Placeholder.STRING).then(PatternKey.literal("count"), TypeMapper.of(Material::getCount), Placeholder.NUMBER).then(PatternKey.literal("components"), TypeMapper.of(Material::getComponents), Placeholder.DATA_COMPONENTS).overwrite(Placeholder.ID, TypeMapper.of(Material::getId)));
    private final boolean tag;
    @NotNull
    private final class_2960 id;
    private final int count;
    @NotNull
    private final class_9326 components;
    private final transient OnLoadSupplier<List<class_1792>> items = OnLoadSupplier.of(() -> {
        ArrayList<class_1792> tmp = new ArrayList<class_1792>();
        if (this.isTag()) {
            for (class_6880 holder : TagUtil.forEntries(class_7924.field_41197, this.getId())) {
                tmp.add((class_1792)holder.comp_349());
            }
        } else {
            tmp.add((class_1792)class_7923.field_41178.method_63535(this.getId()));
        }
        if (tmp.isEmpty()) {
            tmp.add(class_1802.field_8162);
        }
        return ImmutableList.copyOf(tmp);
    });

    public Material(class_1799 stack) {
        this(String.valueOf(stack.method_7909().arch$registryName()), stack.method_57380(), stack.method_7947());
    }

    public Material(@NotNull String name) {
        this(name, class_9326.field_49588, 2);
    }

    public Material(@NotNull String name, @NotNull class_9326 components, int count) {
        if (name.startsWith("#")) {
            this.tag = true;
            this.id = class_2960.method_60654((String)name.substring(1));
            this.count = count;
        } else {
            this.tag = false;
            this.id = class_2960.method_60654((String)name);
            this.count = count;
        }
        this.components = components;
    }

    public boolean isTag() {
        return this.tag;
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @NotNull
    public class_9326 getComponents() {
        return this.components;
    }

    public String getName() {
        return this.isTag() ? "#" + String.valueOf(this.getId()) : this.getId().toString();
    }

    @NotNull
    public class_1792 getItem() {
        return this.getItems().getFirst();
    }

    public List<class_1792> getItems() {
        return this.items.get();
    }

    public class_1799 getStack() {
        class_1799 stack = new class_1799((class_1935)this.getItem());
        stack.method_57366(this.getComponents());
        stack.method_7939(this.getCount());
        return stack;
    }

    public int getCount() {
        return this.count;
    }
}

