/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.element.item;

import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.element.Element;
import cool.muyucloud.croparia.api.element.ElementAccess;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ElementalPotion
extends class_1792
implements ElementAccess {
    private static final Map<Element, ElementalPotion> POTIONS = new HashMap<Element, ElementalPotion>();
    private final Element element;

    public ElementalPotion(@NotNull Element element, @NotNull class_1792.class_1793 properties) {
        super(properties);
        if (element == Element.EMPTY) {
            throw new IllegalArgumentException("ElementalPotion cannot be empty element");
        }
        this.element = element;
        POTIONS.put(element, this);
        class_2315.method_10009((class_1935)this, (blockSource, itemStack) -> {
            class_3218 world = blockSource.comp_1967();
            class_2338 sourcePos = blockSource.comp_1968();
            class_2680 sourceState = blockSource.comp_1969();
            class_2350 direction = (class_2350)sourceState.method_11654((class_2769)class_2315.field_10918);
            class_2338 targetPos = sourcePos.method_10081(direction.method_62675());
            class_2680 targetState = blockSource.comp_1967().method_8320(targetPos);
            class_2248 targetBlock = targetState.method_26204();
            if (targetBlock instanceof Infusor) {
                Infusor infusor = (Infusor)targetBlock;
                if (!infusor.tryInfuse((class_1937)world, targetPos, this, itemStack, null)) {
                    infusor.placeItem((class_1937)world, targetPos, itemStack.method_7971(1), null);
                }
            } else if (targetBlock instanceof ItemPlaceable) {
                ItemPlaceable placeable = (ItemPlaceable)targetBlock;
                placeable.placeItem((class_1937)world, targetPos, itemStack.method_7971(1), null);
            } else {
                class_2347.method_10134((class_1937)world, (class_1799)itemStack.method_7971(1), (int)1, (class_2350)direction, (class_2374)targetPos.method_46558());
            }
            return itemStack;
        });
    }

    @Override
    @NotNull
    public Element getElement() {
        return this.element;
    }

    public static Optional<ElementalPotion> fromElement(Element element) {
        return Optional.ofNullable(POTIONS.get(element));
    }

    @NotNull
    public class_2561 method_7864(class_1799 itemStack) {
        class_5250 elemName = Texts.translatable(this.getElement().getTranslationKey(), new Object[0]);
        return Texts.translatable("item.croparia.element.potion", elemName);
    }
}

