/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.generator;

import com.google.gson.JsonParseException;
import com.mojang.serialization.MapCodec;
import cool.muyucloud.croparia.api.generator.DataGenerator;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import cool.muyucloud.croparia.api.generator.util.DgEntry;
import cool.muyucloud.croparia.api.generator.util.DgRegistry;
import cool.muyucloud.croparia.api.generator.util.TranslatableEntry;
import cool.muyucloud.croparia.api.placeholder.PatternKey;
import cool.muyucloud.croparia.api.placeholder.Placeholder;
import cool.muyucloud.croparia.api.placeholder.Template;
import cool.muyucloud.croparia.api.placeholder.TypeMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.class_2960;

public class LangGenerator
extends DataGenerator {
    public static final MapCodec<LangGenerator> CODEC = DataGenerator.CODEC.xmap(dg -> {
        try {
            DgRegistry<? extends DgEntry> translatable = dg.getRegistry();
            Iterator iterator = translatable.iterator();
            if (iterator.hasNext()) {
                TranslatableEntry element = (TranslatableEntry)iterator.next();
                element.translate("en_us");
            }
            return new LangGenerator(dg.isEnabled(), dg.isStartup(), dg.getWhitelist(), dg.getPath(), (DgRegistry<? extends TranslatableEntry>)translatable, dg.getTemplate());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Iterable %s is not translatable".formatted(dg.getRegistry()), e);
        }
    }, lg -> lg);

    public LangGenerator(boolean enabled, boolean startup, List<class_2960> whitelist, Template path, DgRegistry<? extends TranslatableEntry> registry, Template template) {
        super(enabled, startup, whitelist, path, registry, template);
    }

    @Override
    public void onGenerated(PackHandler handler) {
        handler.getAll(this).forEach(entry -> {
            StringBuilder builder = new StringBuilder("{\n");
            Object patt0$temp = entry.value();
            if (patt0$temp instanceof Collection) {
                Collection translations = (Collection)patt0$temp;
                translations.forEach(translation -> builder.append("  ").append(translation.toString()).append(",\n"));
                Object generated = builder.isEmpty() ? "" : builder.substring(0, builder.length() - 2);
                generated = (String)generated + "\n}";
                handler.cache(entry.path(), generated, this);
            }
        });
    }

    @Override
    protected void generate(DgEntry entry, PackHandler pack) {
        if (entry instanceof TranslatableEntry) {
            TranslatableEntry translatable = (TranslatableEntry)entry;
            AtomicReference<String> langRef = new AtomicReference<String>();
            Placeholder parser = Placeholder.build(builder -> builder.then(PatternKey.literal("lang"), TypeMapper.of(e -> (String)langRef.get()), Placeholder.STRING).overwrite(entry.placeholder(), TypeMapper.identity()));
            Function<String, String> preProcess = placeholder -> placeholder.replaceAll("_lang", (String)langRef.get());
            for (String lang : translatable.getLangs()) {
                langRef.set(lang);
                String path = this.getPath().parse(entry, parser, preProcess);
                Collection translations = pack.occupy(this, path).map(value -> {
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        return collection;
                    }
                    return null;
                }).orElseGet(() -> pack.cache(path, new ArrayList(), this));
                translations.add(this.getTemplate().parse(entry, parser, preProcess));
            }
        } else {
            throw new JsonParseException("Entry %s is not translatable".formatted(entry));
        }
    }
}

