/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import cool.muyucloud.croparia.api.generator.util.DgReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tomlj.JsonOptions;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

public interface JsonTransformer {
    public static final Map<String, JsonTransformer> TRANSFORMERS = new HashMap<String, JsonTransformer>(Map.of("json", JsonParser::parseString, "cdg", DgReader::read, "toml", raw -> {
        TomlParseResult toml = Toml.parse((String)raw);
        if (toml.hasErrors()) {
            throw new JsonSyntaxException("Failed to parse TOML: " + String.valueOf(toml.errors()));
        }
        return JsonParser.parseString((String)toml.toJson(new JsonOptions[0]));
    }));

    public static JsonElement transform(File file) throws IOException {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == name.length() - 1) {
            throw new JsonParseException("File must have an extension: " + name);
        }
        String ext = name.substring(dotIndex + 1).toLowerCase();
        JsonTransformer transformer = TRANSFORMERS.getOrDefault(ext, JsonParser::parseString);
        if (transformer == null) {
            throw new JsonParseException("No transformer found for extension: " + ext);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            JsonElement jsonElement = transformer.transform(new String(stream.readAllBytes()));
            return jsonElement;
        }
    }

    public JsonElement transform(String var1);
}

