/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.core.component.BlockProperties;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class BlockOutput
implements class_10302 {
    public static final Codec<BlockOutput> CODEC_STR = class_2960.field_25139.xmap(BlockOutput::create, BlockOutput::getId);
    public static final MapCodec<BlockOutput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(BlockOutput::getId), (App)BlockProperties.CODEC.optionalFieldOf("properties").forGetter(blockOutput -> Optional.of(blockOutput.getProperties()))).apply((Applicative)instance, (id, properties) -> BlockOutput.create(id, properties.orElse(BlockProperties.EMPTY))));
    public static final MultiCodec<BlockOutput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getProperties().isEmpty()) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final class_9139<class_9129, BlockOutput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final class_10302.class_10312<BlockOutput> TYPE = new class_10302.class_10312(CODEC_COMP, STREAM_CODEC);
    public static final class_1799 STACK_UNKNOWN = class_1802.field_8542.method_7854();
    public static final class_1799 STACK_AIR = class_1802.field_8077.method_7854();
    @NotNull
    private final class_2960 id;
    @NotNull
    private final BlockProperties properties;
    private final transient class_1799 displayStack;

    public static BlockOutput create(@NotNull class_2960 id) {
        return BlockOutput.create(id, BlockProperties.EMPTY);
    }

    protected static BlockOutput create(@NotNull class_2960 id, @NotNull BlockProperties properties) {
        return new BlockOutput(id, properties);
    }

    public static BlockOutput of(class_2680 state) {
        return BlockOutput.create(Objects.requireNonNull(state.method_26204().arch$registryName()), BlockProperties.extract(state));
    }

    protected BlockOutput(@NotNull class_2960 id, @NotNull BlockProperties properties) {
        this.id = id;
        this.properties = properties;
        this.displayStack = class_7923.field_41175.method_17966(this.getId()).map(block -> {
            class_1799 stack = block.method_8389().method_7854();
            stack.method_57379(BlockProperties.TYPE, (Object)this.getProperties());
            return stack;
        }).orElseThrow(() -> new IllegalArgumentException("Unknown block: " + String.valueOf(id)));
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    public class_2248 getBlock() {
        return class_7923.field_41175.method_17966(this.getId()).orElse(null);
    }

    @NotNull
    public BlockProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public class_1799 getDisplayStack() {
        return this.displayStack;
    }

    public boolean matches(@NotNull class_2248 block) {
        return Objects.equals(block.arch$registryName(), this.getId());
    }

    public boolean matches(@NotNull class_2680 state) {
        return this.matches(state.method_26204()) && this.getProperties().isSubsetOf(state);
    }

    public void setBlock(class_3218 level, class_2338 pos) {
        class_2680 state = this.getBlock().method_9564();
        state = StateHolderAccess.apply(state, this.getProperties());
        level.method_8652(pos, state, 3);
    }

    @NotNull
    public <T> Stream<T> method_64739(class_10352 contextMap, class_10358<T> factory) {
        if (factory instanceof class_10358.class_10360) {
            class_10358.class_10360 forStacks = (class_10358.class_10360)factory;
            return Stream.of(forStacks.method_64999(this.getDisplayStack()));
        }
        return Stream.empty();
    }

    @NotNull
    public class_10302.class_10312<? extends class_10302> method_64736() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockOutput)) {
            return false;
        }
        BlockOutput that = (BlockOutput)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.properties, that.properties) && Objects.equals(this.displayStack, that.displayStack);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.properties, this.displayStack);
    }

    static {
        STACK_AIR.method_57379(class_9334.field_49631, (Object)Texts.translatable("tooltip.croparia.air", new Object[0]));
    }
}

