/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.entry.BlockInput;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.CifUtil;
import cool.muyucloud.croparia.util.TagUtil;
import cool.muyucloud.croparia.util.supplier.OnLoadSupplier;
import cool.muyucloud.croparia.util.text.Texts;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9329;
import net.minecraft.class_9331;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemInput
implements class_10302 {
    public static final ItemInput EMPTY = new ItemInput(null, null, class_9329.field_49597, 0L);
    public static final Codec<ItemInput> CODEC_STR = Codec.STRING.xmap(s -> s.isEmpty() ? EMPTY : new ItemInput((String)s, 1), ItemInput::getTaggable);
    public static final MapCodec<ItemInput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("id").forGetter(ItemInput::getId), (App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("tag").forGetter(ItemInput::getTag), (App)class_9329.field_49595.optionalFieldOf("components", (Object)class_9329.field_49597).forGetter(ItemInput::getComponentsPredicate), (App)Codec.LONG.optionalFieldOf("amount", (Object)1L).forGetter(ItemInput::getAmount)).apply((Applicative)instance, (id, tag, components, amount) -> id.isEmpty() && tag.isEmpty() && components.equals((Object)class_9329.field_49597) || amount <= 0L ? EMPTY : new ItemInput(id.orElse(null), (class_6862<class_1792>)((class_6862)tag.orElse(null)), (class_9329)components, (long)amount)));
    public static final MultiCodec<ItemInput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getComponentsPredicate().equals((Object)class_9329.field_49597) && toEncode.getAmount() == 1L || toEncode.equals(EMPTY)) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final class_9139<class_9129, ItemInput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final class_10302.class_10312<ItemInput> TYPE = new class_10302.class_10312(CODEC_COMP, STREAM_CODEC);
    @Nullable
    private final class_2960 id;
    @Nullable
    private final class_6862<class_1792> tag;
    @NotNull
    private final class_9329 componentPredicate;
    private final long amount;
    private transient OnLoadSupplier<ImmutableList<class_1799>> displayStacks;

    public static ItemInput of(class_2960 id) {
        return new ItemInput(id, null, class_9329.field_49597, 1L);
    }

    public static ItemInput ofTag(class_2960 id) {
        return new ItemInput(null, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id), class_9329.field_49597, 1L);
    }

    public static ItemInput of(class_1799 stack) {
        class_9329.class_9330 builder = class_9329.method_57862();
        stack.method_57380().method_57846().forEach(entry -> ((Optional)entry.getValue()).ifPresent(value -> builder.method_64097(class_9336.method_57945((class_9331)((class_9331)entry.getKey()), (Object)value))));
        return new ItemInput(stack.method_7909().arch$registryName(), null, builder.method_57871(), stack.method_7947());
    }

    public ItemInput(String s, int amount) {
        this(s.startsWith("#") ? null : class_2960.method_60654((String)s), s.startsWith("#") ? class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)s.substring(1))) : null, class_9329.field_49597, amount);
    }

    public ItemInput(@NotNull class_2960 id, int amount) {
        this(id, null, class_9329.field_49597, amount);
    }

    public ItemInput(@NotNull class_1799 stack) {
        this(stack.method_7909().arch$registryName(), null, CifUtil.extractPredicate(stack.method_57380()), stack.method_7947());
    }

    public ItemInput(@Nullable class_2960 id, @Nullable class_6862<class_1792> tag, @NotNull class_9329 componentPredicate, long amount) {
        this.id = id;
        this.tag = tag;
        if (this.id != null && this.tag != null) {
            throw new IllegalArgumentException("id and tag cannot be set at the same time");
        }
        this.componentPredicate = componentPredicate;
        this.amount = amount;
        this.displayStacks = OnLoadSupplier.of(() -> {
            if (this.getId().isPresent()) {
                class_1799 stack = new class_1799(class_6880.method_40223((Object)((class_1792)class_7923.field_41178.method_63535(this.getId().get()))), Math.toIntExact(this.getAmount()), this.getComponentsPredicate().method_57870());
                if (stack.method_7960()) {
                    DisplayableRecipe.LOGGER.error("Item with id '{}' not found, using placeholder", (Object)this.getId().get());
                    return ImmutableList.of((Object)Texts.tooltip(BlockInput.STACK_UNKNOWN.method_7972(), Texts.literal(this.getTaggable(), new class_2583[0])));
                }
                return ImmutableList.of((Object)stack);
            }
            if (this.getTag().isPresent()) {
                LinkedList stacks = new LinkedList();
                TagUtil.forEntries(this.getTag().get()).forEach(entry -> {
                    class_1799 stack = new class_1799(entry, (int)Math.min(this.getAmount(), Integer.MAX_VALUE), this.getComponentsPredicate().method_57870());
                    stacks.addLast(stack);
                });
                if (stacks.isEmpty()) {
                    DisplayableRecipe.LOGGER.error("Item tag with id '{}' is empty, using placeholder", (Object)this.getTag().get().comp_327());
                    return ImmutableList.of((Object)Texts.tooltip(BlockInput.STACK_UNKNOWN.method_7972(), Texts.literal(this.getTaggable(), new class_2583[0])));
                }
                return ImmutableList.copyOf(stacks);
            }
            class_1799 stack = new class_1799(class_6880.method_40223((Object)((class_1792)CropariaItems.PLACEHOLDER.get())), (int)Math.min(this.getAmount(), Integer.MAX_VALUE), this.getComponentsPredicate().method_57870());
            return ImmutableList.of((Object)stack);
        });
    }

    public String getTaggable() {
        return this.getTag().map(tag -> "#" + String.valueOf(tag.comp_327())).orElseGet(() -> this.getId().map(class_2960::toString).orElse(""));
    }

    public Optional<class_2960> getId() {
        return Optional.ofNullable(this.id);
    }

    public class_2960 getDisplayId() {
        return this.getTag().map(class_6862::comp_327).orElse(((class_1799)this.getDisplayStacks().getFirst()).method_7909().arch$registryName());
    }

    public Optional<class_6862<class_1792>> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @NotNull
    public class_9329 getComponentsPredicate() {
        return this.componentPredicate;
    }

    public Optional<class_9329> optionalComponents() {
        if (this.componentPredicate == class_9329.field_49597) {
            return Optional.empty();
        }
        return Optional.of(this.componentPredicate);
    }

    public long getAmount() {
        return this.amount;
    }

    public ImmutableList<class_1799> getDisplayStacks() {
        return this.displayStacks.get();
    }

    public void mapStacks(Function<ImmutableList<class_1799>, ImmutableList<class_1799>> mapper) {
        this.displayStacks = this.displayStacks.map(mapper);
    }

    public boolean matches(@NotNull class_1792 item) {
        if (this.getId().isPresent()) {
            return this.getId().get().equals((Object)item.arch$registryName());
        }
        if (this.getTag().isPresent()) {
            return TagUtil.isIn(this.getTag().get(), item);
        }
        return true;
    }

    public boolean matches(@NotNull class_9323 components) {
        return this.getComponentsPredicate().method_57868(components);
    }

    public boolean matches(@NotNull ItemSpec item) {
        return this.matches(item.getResource()) && this.matches(item.method_57353());
    }

    public boolean matches(@NotNull class_1799 stack) {
        return this.matchType(stack) && this.getAmount() <= (long)stack.method_7947();
    }

    public boolean matchType(@NotNull class_1799 stack) {
        return this.matches(stack.method_7909()) && this.matches(stack.method_57353());
    }

    public boolean matches(@NotNull ItemSpec item, long amount) {
        return this.matches(item) && this.getAmount() <= amount;
    }

    @NotNull
    public <T> Stream<T> method_64739(class_10352 contextMap, class_10358<T> factory) {
        if (factory instanceof class_10358.class_10360) {
            class_10358.class_10360 forStacks = (class_10358.class_10360)factory;
            return this.getDisplayStacks().stream().map(arg_0 -> ((class_10358.class_10360)forStacks).method_64999(arg_0));
        }
        return Stream.empty();
    }

    @NotNull
    public class_10302.class_10312<? extends class_10302> method_64736() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemInput)) {
            return false;
        }
        ItemInput itemInput = (ItemInput)o;
        return this.amount == itemInput.amount && Objects.equals(this.id, itemInput.id) && Objects.equals(this.tag, itemInput.tag) && Objects.equals(this.componentPredicate, itemInput.componentPredicate) && Objects.equals(this.displayStacks, itemInput.displayStacks);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.componentPredicate, this.amount, this.displayStacks);
    }
}

