/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.entry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.codec.CodecUtil;
import cool.muyucloud.croparia.api.codec.MultiCodec;
import cool.muyucloud.croparia.api.codec.TestedCodec;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;

public class ItemOutput
implements class_10302 {
    public static final Codec<ItemOutput> CODEC_STR = class_2960.field_25139.xmap(id -> new ItemOutput((class_2960)id, 1), ItemOutput::getId);
    public static final MapCodec<ItemOutput> CODEC_COMP = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(ItemOutput::getId), (App)class_9326.field_49589.optionalFieldOf("components").forGetter(itemOutput -> Optional.of(itemOutput.getComponentsPatch())), (App)Codec.LONG.optionalFieldOf("amount").forGetter(result -> Optional.of(result.getAmount()))).apply((Applicative)instance, (id, components, amount) -> new ItemOutput((class_2960)id, components.orElse(class_9326.field_49588), amount.orElse(1L))));
    public static final MultiCodec<ItemOutput> CODEC = CodecUtil.of(CodecUtil.of(CODEC_COMP.codec(), toEncode -> {
        if (toEncode.getComponentsPatch().method_57848() && toEncode.getAmount() == 1L) {
            return TestedCodec.fail(() -> "Can be encoded as string");
        }
        return TestedCodec.success();
    }), CODEC_STR);
    public static final class_9139<class_9129, ItemOutput> STREAM_CODEC = CodecUtil.toStream(CODEC);
    public static final class_10302.class_10312<ItemOutput> TYPE = new class_10302.class_10312(CODEC_COMP, STREAM_CODEC);
    @NotNull
    private final class_2960 id;
    @NotNull
    private final class_9326 components;
    private final long amount;
    @NotNull
    private final transient ItemSpec itemSpec;
    @NotNull
    private final transient class_1799 displayStack;

    public static ItemOutput of(@NotNull class_1799 stack) {
        return new ItemOutput(stack);
    }

    public ItemOutput(@NotNull class_1799 stack) {
        this(Objects.requireNonNull(stack.method_7909().arch$registryName()), stack.method_57380(), stack.method_7947());
    }

    public ItemOutput(@NotNull class_2960 id, int amount) {
        this(id, class_9326.field_49588, 1L);
    }

    public ItemOutput(@NotNull class_2960 id, @NotNull class_9326 components, long amount) {
        this.id = id;
        this.components = components;
        this.amount = amount;
        if (this.amount <= 0L) {
            CropariaIf.LOGGER.warn("Creating ItemOutput with non-positive amount: {}", (Object)this.amount);
        }
        this.itemSpec = new ItemSpec((class_1792)class_7923.field_41178.method_63535(id), components);
        if (this.itemSpec.isEmpty()) {
            throw new IllegalArgumentException("Unknown or invalid item: " + String.valueOf(id));
        }
        this.displayStack = this.toSpec().createStack(this.getAmount());
    }

    @NotNull
    public class_1799 getDisplayStack() {
        return this.displayStack;
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @NotNull
    public class_9326 getComponentsPatch() {
        return this.components;
    }

    public long getAmount() {
        return this.amount;
    }

    @NotNull
    public ItemSpec toSpec() {
        return this.itemSpec;
    }

    public class_1799 createStack() {
        return this.toSpec().createStack(this.getAmount());
    }

    @NotNull
    public <T> Stream<T> method_64739(class_10352 contextMap, class_10358<T> factory) {
        if (factory instanceof class_10358.class_10360) {
            class_10358.class_10360 forStacks = (class_10358.class_10360)factory;
            return Stream.of(forStacks.method_64999(this.getDisplayStack()));
        }
        return Stream.empty();
    }

    @NotNull
    public class_10302.class_10312<? extends class_10302> method_64736() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemOutput)) {
            return false;
        }
        ItemOutput that = (ItemOutput)o;
        return this.amount == that.amount && Objects.equals(this.id, that.id) && Objects.equals(this.components, that.components) && Objects.equals(this.itemSpec, that.itemSpec) && Objects.equals(this.displayStack, that.displayStack);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.components, this.amount, this.itemSpec, this.displayStack);
    }
}

