/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.structure;

import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.util.Vec2i;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class Char2D
implements Iterable<char[]> {
    public static final Codec<Char2D> CODEC = Codec.STRING.listOf().xmap(Char2D::new, Char2D::layer);
    private final char[][] chars;
    private final transient Map<Character, Integer> counts = new HashMap<Character, Integer>();
    private final transient int hash;

    public Char2D(List<String> layer) {
        if (layer.isEmpty()) {
            throw new IllegalArgumentException("Empty surface");
        }
        int cols = layer.getFirst().length();
        int rows = layer.size();
        this.chars = new char[rows][cols];
        for (int z = 0; z < rows; ++z) {
            String row = layer.get(z);
            if (row.length() != cols) {
                throw new IllegalArgumentException("Varying length: " + String.valueOf(layer));
            }
            this.chars[z] = row.toCharArray();
            for (char c : this.chars[z]) {
                this.counts.compute(Character.valueOf(c), (character, integer) -> integer == null ? 1 : integer + 1);
            }
        }
        this.hash = Arrays.deepHashCode((Object[])this.chars);
    }

    public Char2D(int maxX, int maxZ) {
        this.chars = new char[maxZ][maxX];
        this.hash = Arrays.deepHashCode((Object[])this.chars);
    }

    public List<String> layer() {
        return Arrays.stream(this.chars).map(String::new).toList();
    }

    public int maxZ() {
        return this.chars.length;
    }

    public int maxX() {
        return this.chars.length == 0 ? 0 : this.chars[0].length;
    }

    public Char2D rotate() {
        Char2D rotated = new Char2D(this.maxX(), this.maxZ());
        for (int z = 0; z < this.maxZ(); ++z) {
            for (int x = 0; x < this.maxX(); ++x) {
                rotated.chars[x][this.maxZ() - z - 1] = this.chars[z][x];
            }
        }
        return rotated;
    }

    public Char2D mirror() {
        Char2D mirrored = new Char2D(this.maxZ(), this.maxX());
        for (int z = 0; z < this.maxZ(); ++z) {
            for (int x = 0; x < this.maxX(); ++x) {
                mirrored.chars[z][this.maxX() - x - 1] = this.chars[z][x];
            }
        }
        return mirrored;
    }

    public char get(int x, int z) {
        return this.chars[z][x];
    }

    public boolean contains(char c) {
        for (char[] col : this) {
            for (char character : col) {
                if (character != c) continue;
                return true;
            }
        }
        return false;
    }

    public int count(char c) {
        return this.counts.getOrDefault(Character.valueOf(c), 0);
    }

    public Collection<Character> chars() {
        return this.counts.keySet();
    }

    public void forEachChar(BiConsumer<Character, Integer> consumer) {
        this.counts.forEach(consumer);
    }

    public Optional<Vec2i> find(char c) {
        if (this.contains(c)) {
            for (int z = 0; z < this.maxZ(); ++z) {
                for (int x = 0; x < this.maxX(); ++x) {
                    if (this.get(x, z) != c) continue;
                    return Optional.of(Vec2i.of(x, z));
                }
            }
        } else {
            return Optional.empty();
        }
        throw new IllegalStateException("Char %s not present but found %d times".formatted(Character.valueOf(c), this.count(c)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Char2D)) {
            return false;
        }
        Char2D that = (Char2D)o;
        return Objects.deepEquals(this.chars, that.chars);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    @NotNull
    public Iterator<char[]> iterator() {
        return Arrays.stream(this.chars).iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (char[] row : this.chars) {
            builder.append(String.valueOf(row)).append(",\n");
        }
        return builder.substring(0, builder.length() - 2) + "]";
    }

    public static class Char2DIterator
    implements Iterator<Character> {
        private final Char2D char2D;
        private int z = 0;
        private int x = 0;

        public Char2DIterator(Char2D surface) {
            this.char2D = surface;
        }

        @Override
        public boolean hasNext() {
            return this.z >= this.char2D.maxZ();
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                return null;
            }
            char result = this.char2D.get(this.z, this.x);
            ++this.x;
            if (this.x == this.char2D.maxX()) {
                this.x = 0;
                ++this.z;
            }
            return Character.valueOf(result);
        }
    }
}

