/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo;

import com.mojang.logging.LogUtils;
import cool.muyucloud.croparia.api.resource.TypeToken;
import cool.muyucloud.croparia.api.resource.TypeTokenAccess;
import cool.muyucloud.croparia.api.resource.TypedResource;
import org.slf4j.Logger;

public interface Repo<T extends TypedResource<?>>
extends TypeTokenAccess {
    public static final Logger LOGGER = LogUtils.getLogger();

    public int size();

    default public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.isEmpty(i)) continue;
            return false;
        }
        return true;
    }

    public TypeToken<T> getType();

    public boolean isEmpty(int var1);

    public T resourceFor(int var1);

    default public long simConsume(T resource, long amount) {
        long required = amount;
        for (int i = 0; i < this.size() && amount > 0L; amount -= this.simConsume(i, resource, amount), ++i) {
        }
        return required - amount;
    }

    public long simConsume(int var1, T var2, long var3);

    default public long consume(T resource, long amount) {
        long required = amount;
        for (int i = 0; i < this.size() && amount > 0L; amount -= this.consume(i, resource, amount), ++i) {
        }
        return required - amount;
    }

    public long consume(int var1, T var2, long var3);

    default public long simAccept(T resource, long amount) {
        long required = amount;
        for (int i = 0; i < this.size() && amount > 0L; amount -= this.simAccept(i, resource, amount), ++i) {
        }
        return required - amount;
    }

    public long simAccept(int var1, T var2, long var3);

    default public long accept(T resource, long amount) {
        long required = amount;
        for (int i = 0; i < this.size() && amount > 0L; amount -= this.accept(i, resource, amount), ++i) {
        }
        return required - amount;
    }

    public long accept(int var1, T var2, long var3);

    public long capacityFor(int var1, T var2);

    default public long capacityFor(T resource) {
        long amount = 0L;
        for (int i = 0; i < this.size(); ++i) {
            amount += this.capacityFor(i, resource);
        }
        return amount;
    }

    default public long capacityFor(int i) {
        return this.capacityFor(i, this.resourceFor(i));
    }

    public long amountFor(int var1, T var2);

    default public long amountFor(T resource) {
        long amount = 0L;
        for (int i = 0; i < this.size(); ++i) {
            amount += this.amountFor(i, resource);
        }
        return amount;
    }

    default public long amountFor(int i) {
        return this.amountFor(i, this.resourceFor(i));
    }
}

