/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoUnit;
import cool.muyucloud.croparia.api.resource.TypeToken;
import cool.muyucloud.croparia.api.resource.TypedResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;

public class RepoBatch<T extends TypedResource<?>>
implements Repo<T>,
Iterable<RepoUnit<T>> {
    private final ArrayList<RepoUnit<T>> units = new ArrayList();
    private final TypeToken<T> type;

    public static <T extends TypedResource<?>> RepoBatch<T> of(TypeToken<T> type) {
        return new RepoBatch<T>(type, new RepoUnit[0]);
    }

    @SafeVarargs
    public static <T extends TypedResource<?>> RepoBatch<T> of(TypeToken<T> type, RepoUnit<T> ... units) {
        return new RepoBatch<T>(type, units);
    }

    @SafeVarargs
    public static <T extends TypedResource<?>> RepoBatch<T> of(TypeToken<T> type, RepoBatch<T> ... batches) {
        RepoBatch<T> result = new RepoBatch<T>(type, new RepoUnit[0]);
        for (RepoBatch<T> batch : batches) {
            for (RepoUnit<T> unit : batch) {
                result.add(unit);
            }
        }
        return result;
    }

    @SafeVarargs
    public RepoBatch(@NotNull TypeToken<T> type, RepoUnit<T> ... units) {
        this.units.addAll(List.of(units));
        this.units.trimToSize();
        this.type = type;
    }

    @Override
    public TypeToken<T> getType() {
        return this.type;
    }

    public void load(@NotNull JsonArray json) {
        for (int i = 0; i < json.size(); ++i) {
            JsonObject unit = json.get(i).getAsJsonObject();
            this.units.get(i).load(unit);
        }
    }

    public void load(@NotNull class_2499 nbt) {
        for (int i = 0; i < this.units.size(); ++i) {
            class_2487 unit = nbt.method_10602(i);
            this.units.get(i).load(unit);
        }
    }

    public void save(@NotNull JsonArray json) {
        for (int i = 0; i < json.size(); ++i) {
            JsonObject unit = new JsonObject();
            this.units.get(i).save(unit);
            json.add((JsonElement)unit);
        }
    }

    public void save(@NotNull class_2499 nbt) {
        for (RepoUnit<T> tRepoUnit : this.units) {
            class_2487 unit = new class_2487();
            tRepoUnit.save(unit);
            nbt.add((Object)unit);
        }
    }

    public boolean isChanged() {
        for (RepoUnit<T> unit : this.units) {
            if (!unit.isChanged()) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final void add(RepoUnit<T> ... unit) {
        this.units.addAll(List.of(unit));
        this.units.trimToSize();
    }

    @SafeVarargs
    public final void add(RepoBatch<T> ... batches) {
        for (RepoBatch<T> batch : batches) {
            for (RepoUnit<T> unit : batch) {
                this.units.add(unit);
            }
        }
    }

    public RepoUnit<T> remove(int i) {
        return this.units.remove(i);
    }

    public void clear() {
        this.units.clear();
    }

    @Override
    public int size() {
        return this.units.size();
    }

    @Override
    public boolean isEmpty(int i) {
        return this.units.get(i).isEmpty(0);
    }

    @Override
    public T resourceFor(int i) {
        return this.units.get(i).resourceFor(0);
    }

    @Override
    public long simConsume(int i, T resource, long amount) {
        return this.units.get(i).simConsume(0, resource, amount);
    }

    @Override
    public long consume(int i, T resource, long amount) {
        return this.units.get(i).consume(0, resource, amount);
    }

    @Override
    public long simAccept(int i, T resource, long amount) {
        return this.units.get(i).simAccept(0, resource, amount);
    }

    @Override
    public long accept(int i, T resource, long amount) {
        return this.units.get(i).accept(0, resource, amount);
    }

    @Override
    public long capacityFor(int i, T resource) {
        return this.units.get(i).capacityFor(0, resource);
    }

    @Override
    public long amountFor(int i, T resource) {
        return this.units.get(i).amountFor(0, resource);
    }

    @Override
    @NotNull
    public Iterator<RepoUnit<T>> iterator() {
        return this.units.iterator();
    }
}

