/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.fabric;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.platform.PlatformFluidProxy;
import cool.muyucloud.croparia.api.resource.FabricFluidSpec;
import cool.muyucloud.croparia.api.resource.type.FluidSpec;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformFluidProxyImpl
implements PlatformFluidProxy {
    private final Storage<FluidVariant> storage;

    @NotNull
    public static PlatformFluidProxyImpl of(@NotNull Storage<FluidVariant> storage) {
        return new PlatformFluidProxyImpl(storage);
    }

    public PlatformFluidProxyImpl(Storage<FluidVariant> storage) {
        this.storage = storage;
    }

    public Storage<FluidVariant> get() {
        return this.storage;
    }

    @Nullable
    public StorageView<FluidVariant> get(int i) {
        int v;
        Iterator iterator = this.storage.iterator();
        StorageView view = null;
        for (v = 0; iterator.hasNext() && i > v; ++v) {
            view = (StorageView)iterator.next();
        }
        if (i != v || view == null) {
            return null;
        }
        return view;
    }

    @Override
    public Optional<Repo<FluidSpec>> peel() {
        Optional<Repo<FluidSpec>> optional;
        Storage<FluidVariant> storage = this.get();
        if (storage instanceof Repo) {
            Repo fluidRepo = (Repo)storage;
            optional = Optional.of(fluidRepo);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int size() {
        int i = 0;
        for (StorageView ignored : this.get()) {
            ++i;
        }
        return i;
    }

    @Override
    public boolean isEmpty(int i) {
        StorageView<FluidVariant> view = this.get(i);
        return view == null || view.isResourceBlank();
    }

    @Override
    @Nullable
    public FluidSpec resourceFor(int i) {
        StorageView<FluidVariant> view = this.get(i);
        if (view == null) {
            return null;
        }
        return FabricFluidSpec.from((FluidVariant)view.getResource());
    }

    @Override
    public long simConsume(int i, FluidSpec resource, long amount) {
        if (!this.get().supportsExtraction()) {
            return 0L;
        }
        StorageView<FluidVariant> view = this.get(i);
        if (view == null) {
            return 0L;
        }
        return StorageUtil.simulateExtract(view, (Object)FabricFluidSpec.toVariant(resource), (long)amount, null);
    }

    @Override
    public long consume(FluidSpec resource, long amount) {
        if (!this.get().supportsExtraction()) {
            return 0L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long result = this.get().extract((Object)FabricFluidSpec.toVariant(resource), amount, (TransactionContext)transaction);
            transaction.commit();
            long l = result;
            return l;
        }
    }

    @Override
    public long consume(int i, FluidSpec resource, long amount) {
        if (!this.get().supportsExtraction()) {
            return 0L;
        }
        StorageView<FluidVariant> view = this.get(i);
        if (view == null) {
            return 0L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long result = view.extract((Object)FabricFluidSpec.toVariant(resource), amount, (TransactionContext)transaction);
            transaction.commit();
            long l = result;
            return l;
        }
    }

    @Override
    public long simAccept(int i, FluidSpec resource, long amount) {
        if (!this.get().supportsInsertion()) {
            return 0L;
        }
        StorageView<FluidVariant> view = this.get(i);
        if (!(view instanceof Storage)) {
            return 0L;
        }
        Storage s = (Storage)view;
        try {
            Storage storage = s;
            return StorageUtil.simulateInsert((Storage)storage, (Object)FabricFluidSpec.toVariant(resource), (long)amount, null);
        }
        catch (ClassCastException e) {
            return 0L;
        }
    }

    @Override
    public long accept(int i, FluidSpec fluid, long amount) {
        long l;
        block10: {
            if (!this.get().supportsInsertion()) {
                return 0L;
            }
            StorageView<FluidVariant> view = this.get(i);
            if (!(view instanceof Storage)) {
                return 0L;
            }
            Storage s = (Storage)view;
            Storage storage = s;
            Transaction transaction = Transaction.openOuter();
            try {
                long result = storage.insert((Object)FabricFluidSpec.toVariant(fluid), amount, (TransactionContext)transaction);
                transaction.commit();
                l = result;
                if (transaction == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassCastException e) {
                    return 0L;
                }
            }
            transaction.close();
        }
        return l;
    }

    @Override
    public long accept(FluidSpec fluid, long amount) {
        if (!this.get().supportsInsertion()) {
            return 0L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long result = this.get().insert((Object)FabricFluidSpec.toVariant(fluid), amount, (TransactionContext)transaction);
            transaction.commit();
            long l = result;
            return l;
        }
    }

    @Override
    public long capacityFor(int i, FluidSpec fluid) {
        StorageView<FluidVariant> view = this.get(i);
        if (view == null) {
            return 0L;
        }
        if (view.isResourceBlank() || FabricFluidSpec.matches((FluidVariant)view.getResource(), fluid)) {
            return view.getCapacity();
        }
        return 0L;
    }

    @Override
    public long capacityFor(FluidSpec fluid) {
        if (!this.get().supportsInsertion()) {
            return 0L;
        }
        long result = 0L;
        for (StorageView view : this.get()) {
            if (!FabricFluidSpec.matches((FluidVariant)view.getResource(), fluid) && !view.isResourceBlank()) continue;
            result += view.getCapacity();
        }
        return result;
    }

    @Override
    public long amountFor(int i, FluidSpec fluid) {
        StorageView<FluidVariant> view = this.get(i);
        if (view == null || !FabricFluidSpec.matches((FluidVariant)view.getResource(), fluid)) {
            return 0L;
        }
        return view.getAmount();
    }

    @Override
    public long amountFor(FluidSpec fluid) {
        long result = 0L;
        for (StorageView view : this.get()) {
            if (!FabricFluidSpec.matches((FluidVariant)view.getResource(), fluid)) continue;
            result += view.getAmount();
        }
        return result;
    }
}

