/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.jei.drawable;

import cool.muyucloud.croparia.compat.jei.drawable.Drawer;
import cool.muyucloud.croparia.compat.jei.util.KeyboardHandler;
import cool.muyucloud.croparia.compat.jei.util.MouseDragHandler;
import cool.muyucloud.croparia.compat.jei.util.MouseKeyHandler;
import cool.muyucloud.croparia.compat.jei.util.MouseMoveHandler;
import cool.muyucloud.croparia.compat.jei.util.MouseScrollHandler;
import cool.muyucloud.croparia.compat.jei.util.MousedDrawer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.MouseUtil;
import net.minecraft.class_332;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInputManager<T extends AbstractInputManager<T>>
implements IJeiGuiEventListener,
IPlaceable<T>,
IDrawable {
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private final Map<String, MousedDrawer> drawables = new LinkedHashMap<String, MousedDrawer>();
    private final Map<String, MouseScrollHandler<T>> onMouseScroll = new LinkedHashMap<String, MouseScrollHandler<T>>();
    private final Map<String, MouseKeyHandler<T>> onMouseClicked = new LinkedHashMap<String, MouseKeyHandler<T>>();
    private final Map<String, MouseKeyHandler<T>> onMouseReleased = new LinkedHashMap<String, MouseKeyHandler<T>>();
    private final Map<String, MouseDragHandler<T>> onMouseDragged = new LinkedHashMap<String, MouseDragHandler<T>>();
    private final Map<String, MouseMoveHandler<T>> onMouseMoved = new LinkedHashMap<String, MouseMoveHandler<T>>();
    private final Map<String, MouseMoveHandler<T>> onMouseEntered = new LinkedHashMap<String, MouseMoveHandler<T>>();
    private final Map<String, MouseMoveHandler<T>> onMouseExited = new LinkedHashMap<String, MouseMoveHandler<T>>();
    private final Map<String, KeyboardHandler<T>> onKeyPressed = new LinkedHashMap<String, KeyboardHandler<T>>();
    private double absoluteX = 0.0;
    private double absoluteY = 0.0;
    private boolean hovered = false;

    public T getSelf() {
        return (T)this;
    }

    public void onBuild() {
    }

    public T addDrawable(String id, MousedDrawer drawer) {
        this.drawables.put(id, drawer);
        return this.getSelf();
    }

    public T addDrawable(String id, IDrawable drawable) {
        return this.addDrawable(id, (class_332 guiGraphics, int xOffset, int yOffset, double mouseX, double mouseY) -> drawable.draw(guiGraphics, xOffset, yOffset));
    }

    public T addDrawable(String id, Drawer drawable) {
        return this.addDrawable(id, (IDrawable)drawable);
    }

    public T removeDrawable(String id) {
        this.drawables.remove(id);
        return this.getSelf();
    }

    public T clearDrawables() {
        this.drawables.clear();
        return this.getSelf();
    }

    public Stream<Map.Entry<String, MousedDrawer>> streamDrawables() {
        return this.drawables.entrySet().stream();
    }

    public double mouseX() {
        return MouseUtil.getX() - this.absoluteX();
    }

    public double parentMouseX() {
        return this.mouseX() + (double)this.x();
    }

    public double mouseY() {
        return MouseUtil.getY() - this.absoluteY();
    }

    public double parentMouseY() {
        return this.mouseY() + (double)this.y();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.onMouseScroll.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY, scrollDeltaX, scrollDeltaY));
    }

    public T onMouseScrolled(String id, MouseScrollHandler<T> handler) {
        this.onMouseScroll.put(id, handler);
        return this.getSelf();
    }

    public T removeOnMouseScrolled(String id) {
        this.onMouseScroll.remove(id);
        return this.getSelf();
    }

    public T clearOnMouseScrolled() {
        this.onMouseScroll.clear();
        return this.getSelf();
    }

    public T onScrolledUp(String id, MouseScrollHandler<T> handler) {
        return (T)this.onMouseScrolled(id, (manager, mouseX, mouseY, dx, dy) -> dy > 0.0 && handler.handle(manager.getSelf(), mouseX, mouseY, dx, dy));
    }

    public T onScrolledUp(String id, MouseScrollHandler.NoReturn<T> handler) {
        return this.onScrolledUp(id, (MouseScrollHandler<T>)handler);
    }

    public T onScrolledDown(String id, MouseScrollHandler<T> handler) {
        return (T)this.onMouseScrolled(id, (manager, mouseX, mouseY, dx, dy) -> dy < 0.0 && handler.handle(manager.getSelf(), mouseX, mouseY, dx, dy));
    }

    public T onScrolledDown(String id, MouseScrollHandler.NoReturn<T> handler) {
        return this.onScrolledDown(id, (MouseScrollHandler<T>)handler);
    }

    public T onScrolledLeft(String id, MouseScrollHandler<T> handler) {
        return (T)this.onMouseScrolled(id, (manager, mouseX, mouseY, dx, dy) -> dx < 0.0 && handler.handle(manager.getSelf(), mouseX, mouseY, dx, dy));
    }

    public T onScrolledLeft(String id, MouseScrollHandler.NoReturn<T> handler) {
        return this.onScrolledLeft(id, (MouseScrollHandler<T>)handler);
    }

    public T onScrolledRight(String id, MouseScrollHandler<T> handler) {
        return (T)this.onMouseScrolled(id, (manager, mouseX, mouseY, dx, dy) -> dx > 0.0 && handler.handle(manager.getSelf(), mouseX, mouseY, dx, dy));
    }

    public T onScrolledRight(String id, MouseScrollHandler.NoReturn<T> handler) {
        return this.onScrolledRight(id, (MouseScrollHandler<T>)handler);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.onMouseDragged.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY, button, dragX, dragY));
    }

    public T onMouseDragged(String id, MouseDragHandler<T> handler) {
        this.onMouseDragged.put(id, handler);
        return this.getSelf();
    }

    public T removeOnMouseDragged(String id) {
        this.onMouseDragged.remove(id);
        return this.getSelf();
    }

    public T clearOnMouseDragged() {
        this.onMouseDragged.clear();
        return this.getSelf();
    }

    public T onDragUp(String id, MouseDragHandler<T> handler) {
        return (T)this.onMouseDragged(id, (manager, mouseX, mouseY, button, dx, dy) -> dy < 0.0 && handler.handle(manager, mouseX, mouseY, button, dx, dy));
    }

    public T onDragUp(String id, MouseDragHandler.NoReturn<T> handler) {
        return this.onDragUp(id, (MouseDragHandler<T>)handler);
    }

    public T onDragDown(String id, MouseDragHandler<T> handler) {
        return (T)this.onMouseDragged(id, (manager, mouseX, mouseY, button, dx, dy) -> dy > 0.0 && handler.handle(manager, mouseX, mouseY, button, dx, dy));
    }

    public T onDragDown(String id, MouseDragHandler.NoReturn<T> handler) {
        return this.onDragDown(id, (MouseDragHandler<T>)handler);
    }

    public T onDragLeft(String id, MouseDragHandler<T> handler) {
        return (T)this.onMouseDragged(id, (manager, mouseX, mouseY, button, dx, dy) -> dx < 0.0 && handler.handle(manager, mouseX, mouseY, button, dx, dy));
    }

    public T onDragLeft(String id, MouseDragHandler.NoReturn<T> handler) {
        return this.onDragLeft(id, (MouseDragHandler<T>)handler);
    }

    public T onDragRight(String id, MouseDragHandler<T> handler) {
        return (T)this.onMouseDragged(id, (manager, mouseX, mouseY, button, dx, dy) -> dx > 0.0 && handler.handle(manager, mouseX, mouseY, button, dx, dy));
    }

    public T onDragRight(String id, MouseDragHandler.NoReturn<T> handler) {
        return this.onDragRight(id, (MouseDragHandler<T>)handler);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.onMouseClicked.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY, button));
    }

    public T onClicked(String id, MouseKeyHandler<T> handler) {
        this.onMouseClicked.put(id, handler);
        return this.getSelf();
    }

    public T onClicked(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onClicked(id, (MouseKeyHandler<T>)handler);
    }

    public T removeOnClicked(String id) {
        this.onMouseClicked.remove(id);
        return this.getSelf();
    }

    public T clearOnClicked() {
        this.onMouseClicked.clear();
        return this.getSelf();
    }

    public T onLeftClicked(String id, MouseKeyHandler<T> handler) {
        return (T)this.onClicked(id, (T manager, double mouseX, double mouseY, int button) -> button == 0 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onLeftClicked(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onLeftClicked(id, (MouseKeyHandler<T>)handler);
    }

    public T onRightClicked(String id, MouseKeyHandler<T> handler) {
        return (T)this.onClicked(id, (T manager, double mouseX, double mouseY, int button) -> button == 1 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onRightClicked(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onRightClicked(id, (MouseKeyHandler<T>)handler);
    }

    public T onMiddleClicked(String id, MouseKeyHandler<T> handler) {
        return (T)this.onClicked(id, (T manager, double mouseX, double mouseY, int button) -> button == 2 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onMiddleClicked(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onMiddleClicked(id, (MouseKeyHandler<T>)handler);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.onMouseReleased.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY, button));
    }

    public T onReleased(String id, MouseKeyHandler<T> handler) {
        this.onMouseReleased.put(id, handler);
        return this.getSelf();
    }

    public T removeOnReleased(String id) {
        this.onMouseReleased.remove(id);
        return this.getSelf();
    }

    public T clearOnReleased() {
        this.onMouseReleased.clear();
        return this.getSelf();
    }

    public T onLeftReleased(String id, MouseKeyHandler<T> handler) {
        return (T)this.onReleased(id, (manager, mouseX, mouseY, button) -> button == 0 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onLeftReleased(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onLeftReleased(id, (MouseKeyHandler<T>)handler);
    }

    public T onRightReleased(String id, MouseKeyHandler<T> handler) {
        return (T)this.onReleased(id, (manager, mouseX, mouseY, button) -> button == 1 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onRightReleased(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onRightReleased(id, (MouseKeyHandler<T>)handler);
    }

    public T onMiddleReleased(String id, MouseKeyHandler<T> handler) {
        return (T)this.onReleased(id, (manager, mouseX, mouseY, button) -> button == 2 && handler.handle(manager, mouseX, mouseY, button));
    }

    public T onMiddleReleased(String id, MouseKeyHandler.NoReturn<T> handler) {
        return this.onMiddleReleased(id, (MouseKeyHandler<T>)handler);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.absoluteX = MouseUtil.getX() - mouseX;
        this.absoluteY = MouseUtil.getY() - mouseY;
        this.onMouseMoved.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY));
    }

    public T onMouseMoved(String id, MouseMoveHandler<T> handler) {
        this.onMouseMoved.put(id, handler);
        return this.getSelf();
    }

    public T removeOnMouseMoved(String id) {
        this.onMouseMoved.remove(id);
        return this.getSelf();
    }

    public T clearOnMouseMoved() {
        this.onMouseMoved.clear();
        return this.getSelf();
    }

    public T onMouseMoved(String id, MouseMoveHandler.NoReturn<T> handler) {
        return this.onMouseMoved(id, (MouseMoveHandler<T>)handler);
    }

    public T onMouseEntered(String id, MouseMoveHandler<T> handler) {
        this.onMouseEntered.put(id, handler);
        return this.getSelf();
    }

    public T removeOnMouseEntered(String id) {
        this.onMouseEntered.remove(id);
        return this.getSelf();
    }

    public T clearOnMouseEntered() {
        this.onMouseEntered.clear();
        return this.getSelf();
    }

    public T onMouseEntered(String id, MouseMoveHandler.NoReturn<T> handler) {
        return this.onMouseEntered(id, (MouseMoveHandler<T>)handler);
    }

    public T onMouseExited(String id, MouseMoveHandler<T> handler) {
        this.onMouseExited.put(id, handler);
        return this.getSelf();
    }

    public T removeOnMouseExited(String id) {
        this.onMouseExited.remove(id);
        return this.getSelf();
    }

    public T clearOnMouseExited() {
        this.onMouseExited.clear();
        return this.getSelf();
    }

    public T onMouseExited(String id, MouseMoveHandler.NoReturn<T> handler) {
        return this.onMouseExited(id, (MouseMoveHandler<T>)handler);
    }

    public boolean keyPressed(double mouseX, double mouseY, int keyCode, int scanCode, int modifiers) {
        return this.onKeyPressed.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY, keyCode, scanCode, modifiers));
    }

    public T onKeyPressed(String id, KeyboardHandler<T> handler) {
        this.onKeyPressed.put(id, handler);
        return this.getSelf();
    }

    public T removeOnKeyPressed(String id) {
        this.onKeyPressed.remove(id);
        return this.getSelf();
    }

    public T clearOnKeyPressed() {
        this.onKeyPressed.clear();
        return this.getSelf();
    }

    public T onKeyPressed(String id, KeyboardHandler.NoReturn<T> handler) {
        return this.onKeyPressed(id, (KeyboardHandler<T>)handler);
    }

    public T onKeyPressed(String id, int keyCode, KeyboardHandler<T> handler) {
        return (T)this.onKeyPressed(id, (T manager, double mouseX, double mouseY, int k, int scanCode, int modifiers) -> k == keyCode && handler.handle(manager, mouseX, mouseY, k, scanCode, modifiers));
    }

    public T onKeyPressed(String id, int keyCode, KeyboardHandler.NoReturn<T> handler) {
        return this.onKeyPressed(id, keyCode, (KeyboardHandler<T>)handler);
    }

    @NotNull
    public class_8030 getArea() {
        return this.area.toScreenRectangle();
    }

    @NotNull
    public T setPosition(int x, int y) {
        this.area = this.area.setPosition(x, y);
        return this.getSelf();
    }

    public int x() {
        return this.area.x();
    }

    public double absoluteX() {
        return this.absoluteX;
    }

    public int y() {
        return this.area.y();
    }

    public double absoluteY() {
        return this.absoluteY;
    }

    @NotNull
    public T setSize(int width, int height) {
        this.area = new ImmutableRect2i(this.area.x(), this.area.y(), width, height);
        return this.getSelf();
    }

    public int getWidth() {
        return this.area.getWidth();
    }

    public int getHeight() {
        return this.area.getHeight();
    }

    public void draw(@NotNull class_332 guiGraphics, int xOffset, int yOffset) {
        double mouseX = this.mouseX();
        double mouseY = this.mouseY();
        if (0.0 < mouseX && mouseX < (double)this.area.getWidth() && 0.0 < mouseY && mouseY < (double)this.area.getHeight()) {
            if (!this.hovered) {
                this.hovered = true;
                this.onMouseEntered.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY));
            }
        } else if (this.hovered) {
            this.hovered = false;
            this.onMouseExited.values().stream().anyMatch(handler -> handler.handle(this.getSelf(), mouseX, mouseY));
        }
        this.drawables.values().forEach(drawer -> drawer.draw(guiGraphics, xOffset + this.x(), yOffset + this.y(), mouseX + (double)xOffset + (double)this.x(), mouseY + (double)yOffset + (double)this.y()));
    }
}

