/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;

@Immutable
public class RangedVec3i
extends class_2382 {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final int hash;

    public static RangedVec3i maxBounds(int maxX, int maxY, int maxZ, int x, int y, int z) {
        return new RangedVec3i(0, 0, 0, maxX, maxY, maxZ, x, y, z);
    }

    public static RangedVec3i maxBounds(int maxX, int maxY, int maxZ) {
        return RangedVec3i.maxBounds(maxX, maxY, maxZ, 0, 0, 0);
    }

    public static RangedVec3i bounds(int x, int y, int z, int length, int width, int height) {
        return new RangedVec3i(x, y, z, x + length, y + width, z + height, x, y, z);
    }

    public RangedVec3i(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int x, int y, int z) {
        super(Math.min(Math.max(minX, x), maxX), Math.min(Math.max(minY, y), maxY), Math.min(Math.max(minZ, z), maxZ));
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            throw new IllegalArgumentException("Min values must be less than or equal to max values");
        }
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.hash = Objects.hash(minX, minY, minZ, maxX, maxY, maxZ, this.method_10263(), this.method_10264(), this.method_10260());
    }

    public boolean isInside(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean isInside(class_2382 vec) {
        return this.isInside(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public int volume() {
        return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
    }

    @NotNull
    public RangedVec3i multiply(int scalar) {
        return scalar == 0 ? this : new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.method_10263() * scalar, this.method_10264() * scalar, this.method_10260() * scalar);
    }

    @NotNull
    public RangedVec3i relative(@NotNull class_2350 direction, int distance) {
        return distance == 0 ? this : this.offset(direction.method_10148() * distance, direction.method_10164() * distance, direction.method_10165() * distance);
    }

    @NotNull
    public RangedVec3i relative(@NotNull class_2350.class_2351 axis, int amount) {
        return amount == 0 ? this : (amount > 0 ? this.relative(axis.method_64922(), amount) : this.relative(axis.method_64923(), amount));
    }

    @NotNull
    public RangedVec3i cross(@NotNull class_2382 vector) {
        return new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.method_10264() * vector.method_10260() - this.method_10260() * vector.method_10264(), this.method_10260() * vector.method_10263() - this.method_10263() * vector.method_10260(), this.method_10263() * vector.method_10264() - this.method_10264() * vector.method_10263());
    }

    public RangedVec3i min(int minX, int minY, int minZ) {
        return new RangedVec3i(minX, minY, minZ, this.maxX, this.maxY, this.maxZ, this.method_10263(), this.method_10264(), this.method_10260());
    }

    public RangedVec3i min(@NotNull class_2382 min) {
        return this.min(min.method_10263(), min.method_10264(), min.method_10260());
    }

    public RangedVec3i minX(int minX) {
        return this.min(minX, this.minY, this.minZ);
    }

    public RangedVec3i minY(int minY) {
        return this.min(this.minX, minY, this.minZ);
    }

    public RangedVec3i minZ(int minZ) {
        return this.min(this.minX, this.minY, minZ);
    }

    public RangedVec3i max(int maxX, int maxY, int maxZ) {
        return new RangedVec3i(this.minX, this.minY, this.minZ, maxX, maxY, maxZ, this.method_10263(), this.method_10264(), this.method_10260());
    }

    public RangedVec3i max(@NotNull class_2382 max) {
        return this.max(max.method_10263(), max.method_10264(), max.method_10260());
    }

    public RangedVec3i maxX(int maxX) {
        return this.max(maxX, this.maxY, this.maxZ);
    }

    public RangedVec3i maxY(int maxY) {
        return this.max(this.maxX, maxY, this.maxZ);
    }

    public RangedVec3i maxZ(int maxZ) {
        return this.max(this.maxX, this.maxY, maxZ);
    }

    @NotNull
    public RangedVec3i offset(int dx, int dy, int dz) {
        return this.rebuild(this.method_10263() + dx, this.method_10264() + dy, this.method_10260() + dz);
    }

    public RangedVec3i rebuild(int x, int y, int z) {
        RangedVec3i result = new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, x, y, z);
        if (result.equals((Object)this)) {
            return this;
        }
        return result;
    }

    public RangedVec3i rebuild(@NotNull class_2382 vec) {
        return this.rebuild(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public RangedVec3i x(int x) {
        return this.rebuild(x, this.method_10264(), this.method_10260());
    }

    public RangedVec3i y(int y) {
        return this.rebuild(this.method_10263(), y, this.method_10260());
    }

    public RangedVec3i z(int z) {
        return this.rebuild(this.method_10263(), this.method_10264(), z);
    }

    public RangedVec3i dx(int dx) {
        return this.x(this.method_10263() + dx);
    }

    public RangedVec3i dy(int dy) {
        return this.y(this.method_10264() + dy);
    }

    public RangedVec3i dz(int dz) {
        return this.z(this.method_10260() + dz);
    }

    public boolean testX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean testY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean testZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @NotNull
    public RangedVec3i above() {
        return this.above(1);
    }

    @NotNull
    public RangedVec3i above(int distance) {
        return this.relative(class_2350.field_11036, distance);
    }

    @NotNull
    public RangedVec3i below() {
        return this.below(1);
    }

    @NotNull
    public RangedVec3i below(int distance) {
        return this.relative(class_2350.field_11033, distance);
    }

    @NotNull
    public RangedVec3i north() {
        return this.north(1);
    }

    @NotNull
    public RangedVec3i north(int distance) {
        return this.relative(class_2350.field_11043, distance);
    }

    @NotNull
    public RangedVec3i south() {
        return this.south(1);
    }

    @NotNull
    public RangedVec3i south(int distance) {
        return this.relative(class_2350.field_11035, distance);
    }

    @NotNull
    public RangedVec3i west() {
        return this.west(1);
    }

    @NotNull
    public RangedVec3i west(int distance) {
        return this.relative(class_2350.field_11039, distance);
    }

    @NotNull
    public RangedVec3i east() {
        return this.east(1);
    }

    @NotNull
    public RangedVec3i east(int distance) {
        return this.relative(class_2350.field_11034, distance);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof RangedVec3i) {
            RangedVec3i that = (RangedVec3i)((Object)o);
            return this.minX == that.minX && this.minY == that.minY && this.minZ == that.minZ && this.maxX == that.maxX && this.maxY == that.maxY && this.maxZ == that.maxZ;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

