/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Ref<T> {
    private T value;
    private final List<BiConsumer<T, T>> onChanged = new ArrayList<BiConsumer<T, T>>();

    public Ref() {
        this.value = null;
    }

    public Ref(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public Ref<T> set(T value) {
        T old = this.value;
        this.value = value;
        if (!this.value.equals(old)) {
            for (BiConsumer<T, T> consumer : this.onChanged) {
                consumer.accept(old, value);
            }
        }
        return this;
    }

    public Ref<T> map(Function<T, T> mapper) {
        this.set(mapper.apply(this.value));
        return this;
    }

    public boolean mapAndCompare(Function<T, T> mapper) {
        T old = this.value;
        T newValue = mapper.apply(this.value);
        this.set(newValue);
        return newValue.equals(old);
    }

    public Ref<T> onChanged(BiConsumer<T, T> consumer) {
        this.onChanged.add(consumer);
        return this;
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.value);
    }
}

