/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia;

import com.mojang.logging.LogUtils;
import cool.muyucloud.croparia.api.crop.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.generator.BlockTagGenerator;
import cool.muyucloud.croparia.api.generator.ItemTagGenerator;
import cool.muyucloud.croparia.api.generator.pack.DataPackHandler;
import cool.muyucloud.croparia.api.generator.pack.ResourcePackHandler;
import cool.muyucloud.croparia.client.generator.BlockStateModelGenerator;
import cool.muyucloud.croparia.client.generator.ItemModelGenerator;
import cool.muyucloud.croparia.client.generator.LangGenerator;
import cool.muyucloud.croparia.config.Config;
import cool.muyucloud.croparia.config.ConfigFileHandler;
import cool.muyucloud.croparia.registry.BlockEntities;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.registry.Fluids;
import cool.muyucloud.croparia.registry.PlacedFeatures;
import cool.muyucloud.croparia.registry.RecipeSerializers;
import cool.muyucloud.croparia.registry.RecipeTypes;
import cool.muyucloud.croparia.registry.Tabs;
import dev.architectury.event.events.common.LifecycleEvent;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class CropariaIf {
    public static final String MOD_ID = "croparia";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Config CONFIG = ConfigFileHandler.load();

    public static void init() {
        LOGGER.info("=== Croparia common setup ===");
        DataPackHandler.INSTANCE.beforeReload();
        RecipeTypes.register();
        RecipeSerializers.register();
        Crops.register();
        Fluids.register();
        CropariaBlocks.register();
        BlockEntities.register();
        CropariaItems.register();
        Tabs.register();
        LOGGER.debug("Adding data generators");
        DataPackHandler.INSTANCE.registerGenerator(ItemTagGenerator::init);
        DataPackHandler.INSTANCE.registerGenerator(BlockTagGenerator::init);
        ResourcePackHandler.INSTANCE.registerGenerator(ItemModelGenerator::init);
        ResourcePackHandler.INSTANCE.registerGenerator(BlockStateModelGenerator::init);
        ResourcePackHandler.INSTANCE.registerGenerator(LangGenerator::init);
        LifecycleEvent.SETUP.register(PlacedFeatures::init);
        CommonCommandRoot.register();
        LOGGER.debug("Registering common lifecycle events");
        LifecycleEvent.SERVER_STARTING.register(server -> {
            ConfigFileHandler.reload(CONFIG);
            if (CONFIG.getOverride().booleanValue()) {
                DataPackHandler.INSTANCE.clear();
            }
        });
        LifecycleEvent.SERVER_STARTED.register(server -> {
            if (CONFIG.getAutoReload().booleanValue()) {
                LOGGER.info("Croparia IF is performing a datapack reload to apply data generators");
                server.m_129892_().m_82117_(server.m_129893_(), "reload");
            }
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> ConfigFileHandler.save(CONFIG));
        LOGGER.info("=== Croparia common setup done ===");
    }

    public static ResourceLocation of(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

