/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.recipe.InfusorRecipe;
import cool.muyucloud.croparia.api.core.recipe.container.InfusorContainer;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.RecipeTypes;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.Util;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Infusor
extends Block
implements ItemPlaceable {
    protected final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final EnumProperty<ElementsEnum> TYPE = EnumProperty.m_61587_((String)"infusor_type", ElementsEnum.class);

    public Infusor() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 1.0f).m_60999_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)ElementsEnum.EMPTY)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, @Nullable BlockHitResult hit) {
        if (!world.f_46443_) {
            ElementalPotion potion2;
            ItemStack itemStack = player.m_21120_(hand);
            Item item = itemStack.m_41720_();
            if (item instanceof ElementalPotion && this.tryInfuse(world, pos, potion2 = (ElementalPotion)item, itemStack, player)) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    this.forceCraft(serverWorld, pos, player);
                }
                return InteractionResult.SUCCESS;
            }
            if (ElementalPotion.fromElement((ElementsEnum)((Object)state.m_61143_(TYPE))).map(potion -> potion.m_41469_() == item).orElse(false).booleanValue() && this.tryDefuse(world, pos, itemStack, player)) {
                return InteractionResult.SUCCESS;
            }
            if (item != CropariaItems.RECIPE_WIZARD.get() && hand == InteractionHand.MAIN_HAND) {
                this.placeItem(world, pos, itemStack);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean tryInfuse(Level world, BlockPos pos, ElementalPotion potion, @NotNull ItemStack stack, @Nullable Player player) {
        BlockState state = world.m_8055_(pos);
        if (state.m_61143_(TYPE) != ElementsEnum.EMPTY) {
            return false;
        }
        world.m_46597_(pos, (BlockState)((Infusor)CropariaBlocks.INFUSOR.get()).m_49966_().m_61124_(TYPE, (Comparable)((Object)potion.getElement())));
        if (player != null && player.m_150110_().f_35937_) {
            return true;
        }
        stack.m_41774_(1);
        ItemStack returnStack = Objects.requireNonNull(potion.m_41469_()).m_7968_();
        Util.exportItem(world, pos, returnStack, player);
        return true;
    }

    public void forceCraft(ServerLevel world, BlockPos pos, @Nullable Player player) {
        ElementsEnum element = (ElementsEnum)((Object)world.m_8055_(pos).m_61143_(TYPE));
        world.m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), AABB.m_82321_((BoundingBox)new BoundingBox(pos)), entity -> !entity.m_32055_().m_41619_()).forEach(entity -> {
            ItemStack input = entity.m_32055_();
            this.tryCraft(world, pos, input, element, (Player)(player != null ? player : (entity.m_32056_() == null ? null : world.m_46003_(entity.m_32056_()))));
        });
    }

    public boolean tryDefuse(Level world, BlockPos pos, ItemStack stack, @Nullable Player player) {
        Item item = stack.m_41720_();
        BlockState state = world.m_8055_(pos);
        ElementsEnum element = (ElementsEnum)((Object)state.m_61143_(TYPE));
        if (element == ElementsEnum.EMPTY || ElementalPotion.fromElement(element).orElseThrow().m_41469_() != item) {
            return false;
        }
        world.m_46597_(pos, (BlockState)((Infusor)CropariaBlocks.INFUSOR.get()).m_49966_().m_61124_(TYPE, (Comparable)((Object)ElementsEnum.EMPTY)));
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        ItemStack returnStack = ElementalPotion.fromElement(element).orElseThrow().m_7968_();
        Util.exportItem(world, pos, returnStack, player);
        return false;
    }

    public void onCrafting(InfusorRecipe recipe, InfusorContainer container, Level world, BlockPos pos, @Nullable Player player) {
        ItemStack stack = recipe.assemble(container);
        Util.exportItem(world, pos, stack, player);
        world.m_46597_(pos, this.m_49966_());
    }

    public void tryCraft(ServerLevel world, BlockPos pos, ItemStack input, ElementsEnum element, Player player) {
        if (!CropariaIf.CONFIG.getInfusor().booleanValue()) {
            return;
        }
        RecipeManager manager = world.m_142572_().m_129894_();
        InfusorContainer container = InfusorContainer.of(element, input);
        manager.m_44015_((RecipeType)RecipeTypes.INFUSOR.get(), (Container)container, (Level)world).ifPresent(recipe -> this.onCrafting((InfusorRecipe)recipe, container, (Level)world, pos, player));
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (CropariaIf.CONFIG.getInfusor().booleanValue()) {
                    ItemStack input = itemEntity.m_32055_();
                    ElementsEnum element = (ElementsEnum)((Object)state.m_61143_(TYPE));
                    this.tryCraft(serverWorld, pos, input, element, itemEntity.m_32056_() == null ? null : world.m_46003_(itemEntity.m_32056_()));
                }
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE});
    }

    @NotNull
    public Item m_5456_() {
        return (Item)CropariaItems.INFUSOR.get();
    }

    public static ElementsEnum getElement(BlockState state) {
        return (ElementsEnum)((Object)state.m_61143_(TYPE));
    }

    @Override
    public void placeItem(Level world, BlockPos pos, ItemStack stack) {
        Util.placeItem(world, pos, stack);
    }
}

