/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.entity.FakePlayer;
import cool.muyucloud.croparia.api.core.recipe.RitualStructure;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.RecipeTypes;
import cool.muyucloud.croparia.util.ItemPlaceable;
import cool.muyucloud.croparia.util.Util;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualStand
extends Block
implements ItemPlaceable {
    protected final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.3, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private final int tier;
    private LinkedList<ItemEntity> items = new LinkedList();

    public RitualStand(int tier) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56749_).m_60999_());
        this.tier = tier;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!world.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == CropariaItems.RECIPE_WIZARD.get()) {
                return InteractionResult.PASS;
            }
            this.placeItem(world, pos, stack);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(blockState, world, pos, player, hand, blockHitResult);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        ItemEntity itemEntity;
        LinkedList filtered = new LinkedList();
        this.items.stream().filter(item -> !item.m_146910_()).forEach(filtered::add);
        this.items = filtered;
        if (entity instanceof ItemEntity && !this.items.contains(itemEntity = (ItemEntity)entity) && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (CropariaIf.CONFIG.getRitual().booleanValue()) {
                this.items.add(itemEntity);
                ItemStack stack = itemEntity.m_32055_();
                RecipeManager recipeManager = serverWorld.m_142572_().m_129894_();
                this.getRitualStructure(recipeManager).flatMap(structure -> structure.matchesAndDestroy(pos, world)).ifPresentOrElse(inputBlock -> {
                    RitualContainer container = this.getRitualContainer(stack, (BlockState)inputBlock);
                    if (itemEntity.m_32056_() != null) {
                        Player player = world.m_46003_(itemEntity.m_32056_());
                        this.tryCraft(container, serverWorld, pos, player);
                    } else {
                        this.tryCraft(container, serverWorld, pos, null);
                    }
                }, () -> {
                    if (itemEntity.m_32056_() != null) {
                        Player player = world.m_46003_(itemEntity.m_32056_());
                        this.bad("overlay.croparia.ritual.bad", Objects.requireNonNull(player));
                    }
                });
            }
        }
    }

    protected Optional<RitualStructure> getRitualStructure(@NotNull RecipeManager recipeManager) {
        AtomicReference recipe = new AtomicReference();
        recipeManager.m_44056_((RecipeType)RecipeTypes.RITUAL_STRUCTURE.get(), (Container)RitualStructureContainer.INSTANCE, null).forEach(structure -> {
            if (structure.m_6423_().equals((Object)this.arch$registryName())) {
                recipe.set(structure);
            }
        });
        return Optional.ofNullable((RitualStructure)recipe.get());
    }

    protected void tryCraft(@NotNull RitualContainer container, @NotNull ServerLevel world, @NotNull BlockPos pos, @Nullable Player player) {
        if (!CropariaIf.CONFIG.getInfusor().booleanValue()) {
            return;
        }
        world.m_142572_().m_129894_().m_44015_((RecipeType)RecipeTypes.RITUAL.get(), (Container)container, (Level)world).ifPresentOrElse(recipe -> {
            ItemStack result = recipe.assemble(container);
            if (result.m_41720_() instanceof SpawnEggItem) {
                FakePlayer.useAllItemsOn(world, pos, result);
            } else {
                Util.exportItem((Level)world, pos, result, player);
            }
        }, () -> {
            if (player != null) {
                this.bad("overlay.croparia.ritual.rejected", player);
            }
        });
    }

    @NotNull
    public RitualContainer getRitualContainer(@NotNull ItemStack input, @NotNull BlockState block) {
        return new RitualContainer(this.tier, input, block);
    }

    public void bad(@NotNull String translationKey, @NotNull Player player) {
        player.m_5661_((Component)new TranslatableComponent(translationKey), true);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public void placeItem(Level world, BlockPos pos, ItemStack stack) {
        Util.placeItem(world, pos, stack);
    }
}

