/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.block.entity;

import cool.muyucloud.croparia.access.CropBlockAccess;
import cool.muyucloud.croparia.api.repo.ContainerRepo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.registry.BlockEntities;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreenhouseBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private final NonNullList<ItemStack> inventory;
    private final RepoProxy<ItemSpec> proxy = RepoProxy.item(new ContainerRepo(this));

    public GreenhouseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.GREENHOUSE_BE.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    }

    public static void tick(Level level, BlockPos worldPosition, GreenhouseBlockEntity greenHouseBlockEntity) {
        BlockState belowState;
        Block block;
        if (!level.f_46443_ && (block = (belowState = level.m_8055_(worldPosition.m_7495_())).m_60734_()) instanceof CropBlock) {
            CropBlock block2 = (CropBlock)block;
            Item seed = block2.m_7397_((BlockGetter)level, worldPosition, belowState).m_41720_();
            if (block2.m_52307_(belowState)) {
                List droppedStacks = Block.m_49869_((BlockState)belowState, (ServerLevel)Objects.requireNonNull(Objects.requireNonNull(level.m_142572_()).m_129880_(level.m_46472_())), (BlockPos)worldPosition.m_7495_(), (BlockEntity)level.m_7702_(worldPosition.m_7495_()));
                boolean decreased = false;
                for (ItemStack stack : droppedStacks) {
                    if (!decreased && stack.m_150930_(seed)) {
                        stack.m_41774_(1);
                        decreased = true;
                    }
                    GreenhouseBlockEntity.addItemStackInInventory(stack, greenHouseBlockEntity);
                }
                IntegerProperty property = ((CropBlockAccess)block2).croparia_if$invokeGetAgeProperty();
                int maxAge = block2.m_7419_();
                level.m_46597_(worldPosition.m_7495_(), (BlockState)block2.m_49966_().m_61124_((Property)property, (Comparable)Integer.valueOf(maxAge / 2)));
            }
        }
    }

    public static void addItemStackInInventory(ItemStack itemstack, GreenhouseBlockEntity greenHouseBlockEntity) {
        int i = greenHouseBlockEntity.inventory.size();
        ItemStack stack = itemstack;
        for (int j = 0; j < i && !stack.m_41619_(); ++j) {
            if ((greenHouseBlockEntity.m_8020_(j).m_41613_() >= 64 || greenHouseBlockEntity.m_8020_(j).m_41720_() != stack.m_41720_()) && !greenHouseBlockEntity.m_8020_(j).m_41619_()) continue;
            greenHouseBlockEntity.m_6836_(j, new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() + greenHouseBlockEntity.m_8020_(j).m_41613_()));
            stack = new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() - greenHouseBlockEntity.m_8020_(j).m_41613_());
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    protected void m_183515_(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        super.m_183515_(nbt);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        AtomicBoolean empty = new AtomicBoolean(true);
        this.inventory.forEach(itemStack -> {
            if (!itemStack.m_41619_()) {
                empty.set(false);
            }
        });
        return empty.get();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_130674_((String)"Greenhouse");
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new DispenserMenu(syncId, inv, (Container)this);
    }

    @Nullable
    public RepoProxy<ItemSpec> visitItem() {
        return this.proxy;
    }
}

