/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.entity;

import com.mojang.authlib.GameProfile;
import cool.muyucloud.croparia.CropariaIf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FakePlayer
extends Player {
    private static final Map<ServerLevel, FakePlayer> FAKE_PLAYERS = new HashMap<ServerLevel, FakePlayer>();
    private static final int MAX_USES = 64;

    public static void useAllItemsOn(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull ItemStack item) {
        InteractionResult result;
        for (int uses = 64; !item.m_41619_() && uses > 0 && (result = FakePlayer.useItemOn(world, pos, item)) != InteractionResult.FAIL && result != InteractionResult.PASS; --uses) {
            FakePlayer.finishUseItem(item, world);
            if (result != InteractionResult.CONSUME) continue;
            item.m_41774_(1);
        }
    }

    public static FakePlayer getPlayer(@NotNull ServerLevel world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.getOrDefault(world, new FakePlayer((Level)world));
        FAKE_PLAYERS.put(world, fakePlayer);
        return fakePlayer;
    }

    public static InteractionResult useItemOn(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull ItemStack item) {
        return FakePlayer.getPlayer(world).useItemOn(pos, item);
    }

    public static void finishUseItem(@NotNull ItemStack item, @NotNull ServerLevel world) {
        FakePlayer fakePlayer = FakePlayer.getPlayer(world);
        item.m_41671_((Level)world, (LivingEntity)fakePlayer);
    }

    public FakePlayer(@NotNull Level level) {
        super(level, BlockPos.f_121853_, 0.0f, new GameProfile(UUID.randomUUID(), "FakePlayer"));
        CropariaIf.LOGGER.debug("Created fake player for {}", (Object)level.m_46472_());
    }

    public InteractionResult useItemOn(@NotNull BlockPos pos, @NotNull ItemStack item) {
        BlockHitResult hit = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false);
        UseOnContext context = new UseOnContext((Player)this, InteractionHand.MAIN_HAND, hit);
        return item.m_41661_(context);
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_7500_() {
        return false;
    }
}

