/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.item;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.block.RitualStand;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.recipe.predicate.BlockStatePredicate;
import cool.muyucloud.croparia.api.core.recipe.predicate.GenericIngredient;
import cool.muyucloud.croparia.api.crop.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.registry.RecipeTypes;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class RecipeWizard
extends Item {
    private static final Gson GSON = new Gson();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public RecipeWizard(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (!level.m_5776_() || player == null || !player.m_7578_()) {
            return InteractionResult.PASS;
        }
        BlockPos targetPos = context.m_8083_();
        BlockState state = level.m_8055_(targetPos);
        Block target = state.m_60734_();
        if (target instanceof RitualStand) {
            RitualStand ritualStand = (RitualStand)target;
            ResourceLocation id = ritualStand.arch$registryName();
            Optional<BlockState> optionalBlock = this.getRitualInputBlock(id, context.m_43725_(), targetPos);
            if (optionalBlock.isEmpty() || optionalBlock.get().m_60795_()) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.ritual.missing.block"), true);
                return InteractionResult.FAIL;
            }
            Optional<ItemStack> optionalIngredient = this.getItemInput(level, targetPos);
            if (optionalIngredient.isEmpty()) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.ritual.missing.ingredient"), true);
                return InteractionResult.FAIL;
            }
            ItemStack result = player.m_21206_();
            if (result.m_41619_()) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.ritual.missing.result"), true);
                return InteractionResult.FAIL;
            }
            JsonObject recipe = this.assembleRitual(ritualStand, optionalBlock.get(), optionalIngredient.get(), result);
            Path path = this.dumpRecipe(RecipeTypes.RITUAL.getId(), recipe);
            this.sendFeedback("chat.croparia.recipe_wizard.ritual", path, player);
            this.addCooldown(player);
            return InteractionResult.SUCCESS;
        }
        if (target instanceof Infusor) {
            Optional<ItemStack> optionalIngredient = this.getItemInput(level, targetPos);
            if (optionalIngredient.isEmpty()) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.infusor.missing.ingredient"), true);
                return InteractionResult.FAIL;
            }
            ElementsEnum element = Infusor.getElement(state);
            if (element == ElementsEnum.EMPTY) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.infusor.missing.element"), true);
                return InteractionResult.FAIL;
            }
            ItemStack result = player.m_21206_();
            if (result.m_41619_()) {
                player.m_5661_((Component)new TranslatableComponent("overlay.croparia.recipe_wizard.infusor.missing.result"), true);
                return InteractionResult.FAIL;
            }
            JsonObject recipe = this.assembleInfusor(element, optionalIngredient.get(), result);
            Path path = this.dumpRecipe(RecipeTypes.INFUSOR.getId(), recipe);
            this.sendFeedback("chat.croparia.recipe_wizard.infusor", path, player);
            this.addCooldown(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void addCooldown(Player player) {
        player.m_36335_().m_41524_((Item)this, 5);
    }

    public Path dumpRecipe(ResourceLocation recipeType, JsonObject recipe) {
        Path dir = CropariaIf.CONFIG.getDumpPath().resolve(recipeType.m_135815_());
        File dirFile = dir.toFile();
        if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(dir));
        }
        String recipeName = DATE_FORMAT.format(new Date());
        Path location = dir.resolve(recipeName + ".json");
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(location.toFile()));){
            writer.setIndent("  ");
            GSON.toJson((JsonElement)recipe, writer);
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to dump recipe {}", (Object)recipeType, (Object)e);
        }
        return location;
    }

    public void sendFeedback(String key, Path path, Player player) {
        MutableComponent location = new TextComponent(path.getFileName().toString()).m_130948_(CommonCommandRoot.openFile(path.toString())).m_130948_(CommonCommandRoot.inlineMouseBehavior());
        TranslatableComponent main = new TranslatableComponent(key, new Object[]{location});
        player.m_5661_((Component)main, false);
    }

    @NotNull
    public JsonObject assembleRitual(RitualStand ritualStand, BlockState block, ItemStack ingredient, ItemStack result) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "croparia:ritual");
        root.addProperty("tier", (Number)ritualStand.getTier());
        JsonElement encodeBlock = (JsonElement)BlockStatePredicate.Builder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)BlockStatePredicate.ofState(block)).get().orThrow();
        root.add("block", encodeBlock);
        JsonElement encodeIngredient = (JsonElement)GenericIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new GenericIngredient(ingredient)).get().orThrow();
        root.add("ingredient", encodeIngredient);
        JsonElement encodeResult = (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).get().orThrow();
        root.add("result", encodeResult);
        return root;
    }

    @NotNull
    public JsonObject assembleInfusor(ElementsEnum element, ItemStack ingredient, ItemStack result) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "croparia:infusor");
        root.addProperty("element", element.m_7912_());
        JsonElement encodeIngredient = (JsonElement)GenericIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new GenericIngredient(ingredient)).get().orThrow();
        root.add("ingredient", encodeIngredient);
        JsonElement encodeResult = (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).get().orThrow();
        root.add("result", encodeResult);
        return root;
    }

    @NotNull
    public Optional<BlockState> getRitualInputBlock(ResourceLocation id, Level world, BlockPos pos) {
        RecipeManager recipeManager = world.m_7465_();
        AtomicReference result = new AtomicReference();
        recipeManager.m_44056_((RecipeType)RecipeTypes.RITUAL_STRUCTURE.get(), (Container)RitualStructureContainer.INSTANCE, world).forEach(recipe -> {
            if (recipe.m_6423_().equals((Object)id)) {
                recipe.matches(pos, world).ifPresent(result::set);
            }
        });
        return Optional.ofNullable((BlockState)result.get());
    }

    @NotNull
    public Optional<ItemStack> getItemInput(Level world, BlockPos pos) {
        List itemEntities = world.m_45976_(ItemEntity.class, new AABB(pos));
        if (itemEntities.isEmpty() || ((ItemEntity)itemEntities.get(0)).m_146910_() || ((ItemEntity)itemEntities.get(0)).m_32055_().m_41619_()) {
            return Optional.empty();
        }
        return Optional.of(((ItemEntity)itemEntities.get(0)).m_32055_());
    }
}

