/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import cool.muyucloud.croparia.api.core.recipe.container.InfusorContainer;
import cool.muyucloud.croparia.api.core.recipe.predicate.GenericIngredient;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import cool.muyucloud.croparia.api.element.item.ElementalPotion;
import cool.muyucloud.croparia.registry.RecipeSerializers;
import cool.muyucloud.croparia.registry.RecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfusorRecipe
implements Recipe<InfusorContainer> {
    protected ResourceLocation id;
    protected ElementsEnum element = ElementsEnum.ELEMENTAL;
    protected GenericIngredient ingredient;
    protected ItemStack result = ItemStack.f_41583_;

    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        if (result.m_41619_()) {
            throw new IllegalArgumentException("Empty result item %s in recipe %s".formatted(result, this.m_6423_()));
        }
        this.result = result;
    }

    public ElementsEnum getElement() {
        return this.element;
    }

    public void setElement(ElementsEnum element) {
        this.element = element;
    }

    public GenericIngredient getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(@NotNull GenericIngredient ingredient) {
        this.ingredient = ingredient;
    }

    public boolean matches(InfusorContainer container) {
        ItemStack input = container.m_8020_(0);
        return this.ingredient.test(input) && container.getElement() == this.element;
    }

    @NotNull
    public ItemStack assemble(@NotNull InfusorContainer container) {
        if (this.matches(container)) {
            ItemStack input = container.m_8020_(0);
            input.m_41774_(this.ingredient.getCount());
            return this.getResult().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public Item getPotion() {
        return ElementalPotion.fromElement(this.element).orElseThrow();
    }

    public boolean matches(@NotNull InfusorContainer container, @Nullable Level level) {
        return this.matches(container);
    }

    public boolean m_8004_(int i, int j) {
        return i >= 1 && j >= 2 || i >= 2 && j >= 1;
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.getResult().m_41777_();
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.INFUSOR.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.INFUSOR.get();
    }
}

