/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.google.gson.JsonObject;
import cool.muyucloud.croparia.api.core.recipe.RitualRecipe;
import cool.muyucloud.croparia.api.core.recipe.predicate.BlockStatePredicate;
import cool.muyucloud.croparia.api.core.recipe.predicate.GenericIngredient;
import cool.muyucloud.croparia.registry.RecipeSerializers;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OldRitualRecipe
extends RitualRecipe {
    public OldRitualRecipe(@NotNull ResourceLocation id, int tier, @NotNull BlockStatePredicate state, @NotNull ItemStack stack, @NotNull ItemStack result) {
        super(id, tier, state, new GenericIngredient(stack), result);
    }

    public Block extractBlock() {
        if (this.getStateBuilder().isTag()) {
            @Nullable ResourceLocation id = ResourceLocation.m_135820_((String)this.getBlock().getBuilder().getBlock());
            return (Block)Registry.f_122824_.m_7745_(id);
        }
        return Blocks.f_50016_;
    }

    public ItemStack extractItem() {
        List<ItemStack> stacks = this.getIngredient().availableStacks();
        if (stacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return stacks.get(0);
    }

    @NotNull
    public static OldRitualRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        int tier = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
        BlockStatePredicate block = BlockStatePredicate.Builder.create().block(GsonHelper.m_13906_((JsonObject)json, (String)"block")).build();
        Item item = (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"input")));
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Invalid or missing input item in recipe %s".formatted(id));
        }
        ItemStack ingredient = item.m_7968_();
        item = (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"output")));
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Invalid or missing input item in recipe %s".formatted(id));
        }
        ItemStack result = item.m_7968_();
        int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
        result.m_41764_(count);
        return new OldRitualRecipe(id, tier, block, ingredient, result);
    }

    @NotNull
    public static OldRitualRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        int tier = buf.readInt();
        ItemStack ingredient = buf.m_130267_();
        BlockStatePredicate block = BlockStatePredicate.builder().block(Objects.requireNonNull(buf.m_130267_().m_41720_().arch$registryName()).toString()).build();
        ItemStack result = buf.m_130267_();
        result.m_41764_(buf.readInt());
        return new OldRitualRecipe(id, tier, block, ingredient, result);
    }

    public int getResultCount() {
        return this.getResult().m_41613_();
    }

    @Override
    public void toNetwork(@NotNull FriendlyByteBuf buf) {
        if (this.getBlock().isSpecified()) {
            buf.writeInt(this.getTier());
            ItemStack stack = this.extractItem();
            if (stack.m_41619_()) {
                throw new AssertionError((Object)"The specified item does not exist, or declared as AIR");
            }
            buf.m_130055_(stack);
            Block block = this.extractBlock();
            if (block == Blocks.f_50016_) {
                throw new AssertionError((Object)"The specified block does not exist, or declared as AIR");
            }
        } else {
            throw new AssertionError((Object)"The block predicate does not specify a block");
        }
        buf.m_130055_(this.getResult());
        buf.writeInt(this.getResultCount());
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.RITUAL_OLD.get();
    }
}

