/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cool.muyucloud.croparia.api.core.recipe.container.RitualContainer;
import cool.muyucloud.croparia.api.core.recipe.predicate.BlockStatePredicate;
import cool.muyucloud.croparia.api.core.recipe.predicate.GenericIngredient;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.RecipeSerializers;
import cool.muyucloud.croparia.registry.RecipeTypes;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RitualRecipe
implements Recipe<RitualContainer> {
    @NotNull
    private final ResourceLocation id;
    private final int tier;
    @NotNull
    private final BlockStatePredicate block;
    @NotNull
    private final GenericIngredient ingredient;
    @NotNull
    private final ItemStack result;

    public RitualRecipe(@NotNull ResourceLocation id, int tier, @NotNull BlockStatePredicate state, @NotNull GenericIngredient ingredient, @NotNull ItemStack result) {
        this.id = id;
        if (tier < 1) {
            throw new IllegalArgumentException("Tier must be at least 1");
        }
        this.tier = tier;
        this.block = state;
        this.ingredient = ingredient;
        this.result = result;
    }

    public static RitualRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject jsonObject) {
        int tier = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"tier");
        if (tier < 1) {
            throw new IllegalArgumentException("Tier must be at least 1");
        }
        BlockStatePredicate block = ((BlockStatePredicate.Builder)BlockStatePredicate.Builder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("block")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        })).build();
        GenericIngredient ingredient = (GenericIngredient)GenericIngredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("ingredient")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        ItemStack result = (ItemStack)ItemStack.f_41582_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("result")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        return new RitualRecipe(id, tier, block, ingredient, result);
    }

    public static RitualRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        int tier = buf.readInt();
        if (tier < 1) {
            throw new IllegalArgumentException("Tier must be at least 1");
        }
        BlockStatePredicate block = ((BlockStatePredicate.Builder)buf.m_130057_(BlockStatePredicate.Builder.CODEC)).build();
        GenericIngredient ingredient = (GenericIngredient)buf.m_130057_(GenericIngredient.CODEC);
        ItemStack result = buf.m_130267_();
        return new RitualRecipe(id, tier, block, ingredient, result);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.getTier());
        buf.m_130059_(BlockStatePredicate.Builder.CODEC, (Object)this.getStateBuilder());
        buf.m_130059_(GenericIngredient.CODEC, (Object)this.getIngredient());
        buf.m_130055_(this.getResult());
    }

    @NotNull
    public ItemStack getRitualItem() {
        return ((BlockItem)CropariaItems.getRitualStand(this.tier).get()).m_7968_();
    }

    @NotNull
    public Collection<ItemStack> extractBlockItems() {
        return this.block.availableBlockItems();
    }

    @NotNull
    public GenericIngredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public BlockStatePredicate getBlock() {
        return this.block;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    protected BlockStatePredicate.Builder getStateBuilder() {
        return this.block.getBuilder();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean matches(RitualContainer container) {
        int tier = container.tier();
        ItemStack input = container.item();
        BlockState state = container.state();
        return this.ingredient.test(input) && this.block.test(state) && tier >= this.tier;
    }

    public boolean matches(RitualContainer container, Level level) {
        return this.matches(container);
    }

    @NotNull
    public ItemStack assemble(@NotNull RitualContainer container) {
        if (this.matches(container)) {
            container.item().m_41774_(this.getIngredient().getCount());
            return this.getResult().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.RITUAL.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.RITUAL.get();
    }
}

