/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cool.muyucloud.croparia.api.core.recipe.container.RitualStructureContainer;
import cool.muyucloud.croparia.api.core.recipe.predicate.BlockStatePredicate;
import cool.muyucloud.croparia.api.math.Char3D;
import cool.muyucloud.croparia.api.math.Char3DWithMark;
import cool.muyucloud.croparia.registry.RecipeSerializers;
import cool.muyucloud.croparia.registry.RecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualStructure
implements Recipe<RitualStructureContainer> {
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final Map<Character, BlockStatePredicate> keys;
    @NotNull
    protected final List<Char3DWithMark> patterns;

    protected RitualStructure(@NotNull ResourceLocation id, @NotNull Map<Character, BlockStatePredicate> keys, Char3D rawPattern) {
        this.id = id;
        this.patterns = new ArrayList<Char3DWithMark>(8);
        Vec3i ritualOffset = rawPattern.find('*').orElseThrow(() -> new IllegalArgumentException("Invalid pattern, missing ritual marker"));
        Char3DWithMark pattern = new Char3DWithMark(rawPattern, ritualOffset);
        int i = 0;
        do {
            this.patterns.add(pattern);
            pattern = pattern.rotate();
        } while (++i < 4);
        pattern = pattern.mirror();
        i = 0;
        do {
            this.patterns.add(pattern);
            pattern = pattern.rotate();
        } while (++i < 4);
        for (Character c : keys.keySet()) {
            if (Character.isUpperCase(c.charValue()) && Character.isAlphabetic(c.charValue()) && c.charValue() != '*' && c.charValue() != '$' && c.charValue() != ' ' && c.charValue() != '.') continue;
            throw new IllegalArgumentException("Invalid translationKey '%s' in %s, must be uppercase letter".formatted(c, id));
        }
        keys = new HashMap<Character, BlockStatePredicate>(keys);
        this.keys = keys;
    }

    public Collection<BlockStatePredicate> getPredicates() {
        return this.keys.values();
    }

    public Optional<BlockStatePredicate> getPredicate(char key) {
        return Optional.ofNullable(this.keys.get(Character.valueOf(key)));
    }

    public Optional<BlockStatePredicate> getPredicate(int x, int y, int z) {
        return this.getPredicate(this.getChar(x, y, z));
    }

    public char getChar(int x, int y, int z) {
        return this.patterns.get(0).get(x, y, z);
    }

    public int maxX() {
        return this.patterns.get(0).maxX();
    }

    public int maxY() {
        return this.patterns.get(0).maxY();
    }

    public int maxZ() {
        return this.patterns.get(0).maxZ();
    }

    @Nullable
    public BlockState matchTransformed(BlockPos origin, Level level, Char3D pattern, BlockState ritualBlock, boolean destroy) {
        LinkedList<BlockPos> inputPositions = new LinkedList<BlockPos>();
        BlockState inputBlock = null;
        for (int x = 0; x < pattern.maxX(); ++x) {
            for (int y = 0; y < pattern.maxY(); ++y) {
                for (int z = 0; z < pattern.maxZ(); ++z) {
                    BlockStatePredicate predicate;
                    BlockPos pos = origin.m_142082_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    char key = pattern.get(x, y, z);
                    if (key == '$') {
                        if (inputBlock != null && !state.equals(inputBlock)) {
                            return null;
                        }
                        inputPositions.add(pos);
                        inputBlock = state;
                        continue;
                    }
                    if (key == '*') {
                        if (state.equals(ritualBlock)) continue;
                        return null;
                    }
                    if (key == ' ') {
                        BlockStatePredicate.ANY.test(state);
                        continue;
                    }
                    if (!(key == '.' ? !state.m_60795_() : (predicate = this.keys.get(Character.valueOf(key))) == null || !predicate.test(state))) continue;
                    return null;
                }
            }
        }
        if (destroy) {
            for (BlockPos pos : inputPositions) {
                level.m_46961_(pos, false);
            }
        }
        return inputBlock;
    }

    public Optional<BlockState> matchesAndDestroy(BlockPos ritualPos, Level level) {
        BlockState ritualBlock = level.m_8055_(ritualPos);
        for (Char3DWithMark pattern : this.patterns) {
            BlockState inputBlock = this.matchTransformed(pattern.getOriginInWorld(ritualPos), level, pattern, ritualBlock, true);
            if (inputBlock == null) continue;
            return Optional.of(inputBlock);
        }
        return Optional.empty();
    }

    public Optional<BlockState> matches(BlockPos ritualPos, Level level) {
        BlockState ritualBlock = level.m_8055_(ritualPos);
        for (Char3DWithMark pattern : this.patterns) {
            BlockState inputBlock = this.matchTransformed(pattern.getOriginInWorld(ritualPos), level, pattern, ritualBlock, false);
            if (inputBlock == null) continue;
            return Optional.of(inputBlock);
        }
        return Optional.empty();
    }

    public static RitualStructure fromJson(ResourceLocation resourceLocation, JsonObject json) {
        JsonObject rawKeys = GsonHelper.m_13930_((JsonObject)json, (String)"keys");
        HashMap<Character, BlockStatePredicate> keys = new HashMap();
        for (Map.Entry entry : rawKeys.entrySet()) {
            String rawKey = (String)entry.getKey();
            if (rawKey.length() != 1) {
                throw new IllegalArgumentException("Invalid translationKey: " + rawKey);
            }
            Character key = Character.valueOf(rawKey.charAt(0));
            JsonObject rawPredicate = ((JsonElement)entry.getValue()).getAsJsonObject();
            BlockStatePredicate predicate = ((BlockStatePredicate.Builder)BlockStatePredicate.Builder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)rawPredicate).getOrThrow(false, msg -> {
                throw new IllegalArgumentException((String)msg);
            })).build();
            keys.put(key, predicate);
        }
        keys = Map.copyOf(keys);
        Char3D pattern = (Char3D)Char3D.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        return new RitualStructure(resourceLocation, keys, pattern);
    }

    public static RitualStructure fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf inputBuf) {
        Map<Character, BlockStatePredicate> keys = inputBuf.m_178368_(FriendlyByteBuf::readChar, buf -> ((BlockStatePredicate.Builder)buf.m_130057_(BlockStatePredicate.Builder.CODEC)).build());
        keys = Map.copyOf(keys);
        Char3D pattern = (Char3D)inputBuf.m_130057_(Char3D.MAP_CODEC.codec());
        return new RitualStructure(resourceLocation, keys, pattern);
    }

    public void toNetwork(FriendlyByteBuf outputBuf) {
        outputBuf.m_178355_(this.keys, (buf, character) -> buf.writeChar((int)character.charValue()), (buf, predicate) -> buf.m_130059_(BlockStatePredicate.Builder.CODEC, (Object)predicate.getBuilder()));
        outputBuf.m_130059_(Char3D.MAP_CODEC.codec(), (Object)this.patterns.get(0));
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.RITUAL_STRUCTURE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.RITUAL_STRUCTURE.get();
    }

    @Deprecated
    public boolean matches(RitualStructureContainer container, Level level) {
        return true;
    }

    @Deprecated
    @NotNull
    public ItemStack assemble(RitualStructureContainer container) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_8004_(int i, int j) {
        return false;
    }

    @Deprecated
    @NotNull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }
}

