/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.access.StateHolderAccess;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStatePredicate
implements Predicate<BlockState> {
    public static final ItemStack STACK_UNKNOWN = Items.f_41829_.m_7968_().m_41714_((Component)Constants.TOOLTIP_UNKNOWN);
    public static final ItemStack STACK_AIR = Items.f_42127_.m_7968_().m_41714_((Component)Constants.TOOLTIP_AIR);
    public static final ItemStack STACK_ANY = Items.f_42184_.m_7968_().m_41714_((Component)Constants.TOOLTIP_ANY);
    public static final BlockStatePredicate ANY = new BlockStatePredicate(b -> true, b -> true, 0, Builder.create());
    public static final BlockStatePredicate AIR = new BlockStatePredicate(BlockBehaviour.BlockStateBase::m_60795_, b -> true, 0, Builder.create());
    @NotNull
    private final transient Predicate<BlockState> block;
    @NotNull
    private final transient Predicate<BlockState> properties;
    private final transient int hashCode;
    private final Builder builder;

    public BlockStatePredicate(@NotNull Predicate<BlockState> block, @NotNull Predicate<BlockState> properties, int hashCode, Builder builder) {
        this.block = block;
        this.properties = properties;
        this.hashCode = hashCode;
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public boolean test(BlockState state) {
        return this.block.test(state) && this.properties.test(state);
    }

    public static Builder builder() {
        return Builder.create();
    }

    public boolean isSpecified() {
        return this.builder.isTag();
    }

    public Collection<ItemStack> availableBlockItems() {
        if (this.builder.isBlock()) {
            return Collections.singleton(BlockStatePredicate.getBlockItem(ResourceLocation.m_135820_((String)this.builder.getBlock())));
        }
        if (this.builder.isTag()) {
            Iterator blocks = Registry.f_122824_.m_206058_(TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)ResourceLocation.m_135820_((String)Objects.requireNonNull(this.builder.getBlock()).substring(1)))).iterator();
            if (!blocks.hasNext()) {
                return this.builder.properties.isEmpty() ? Collections.singleton(STACK_UNKNOWN) : Collections.singleton(((BlockItem)CropariaItems.PLACEHOLDER_BLOCK.get()).m_7968_());
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            blocks.forEachRemaining(holder -> list.add(((Block)holder.m_203334_()).m_5456_().m_7968_().m_41714_((Component)new TextComponent(this.builder.block))));
            return list;
        }
        return this.builder.properties.isEmpty() ? Collections.singleton(STACK_UNKNOWN) : Collections.singleton(((BlockItem)CropariaItems.PLACEHOLDER_BLOCK.get()).m_7968_());
    }

    public static ItemStack getBlockItem(ResourceLocation id) {
        Block block = Registry.f_122824_.m_6612_(id).orElse(null);
        if (block != null) {
            return block.m_5456_().m_7968_();
        }
        return STACK_UNKNOWN;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public List<Component> tooltip() {
        if (this.builder.properties.isEmpty()) {
            return List.of();
        }
        LinkedList<Component> components = new LinkedList<Component>();
        this.builder.properties.forEach((property, value) -> components.add((Component)new TextComponent("%s=%s".formatted(property, value))));
        return components;
    }

    public static Builder ofState(BlockState state) {
        Builder builder = Builder.create();
        builder.block(Objects.requireNonNull(state.m_60734_().arch$registryName()).toString());
        builder.properties(((StateHolderAccess)state).croparia_if$getProperties());
        return builder;
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("block").forGetter(builder -> Optional.ofNullable(builder.getBlock())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties").forGetter(builder -> builder.properties.isEmpty() ? Optional.empty() : Optional.of(builder.properties))).apply((Applicative)instance, (block, properties) -> {
            Builder builder = Builder.create();
            block.ifPresent(builder::block);
            properties.ifPresent(builder::properties);
            return builder;
        }));
        private boolean built = false;
        @Nullable
        private String block = null;
        @NotNull
        private final Map<String, String> properties = new HashMap<String, String>();
        private transient boolean tag = false;

        public static Builder create() {
            return new Builder();
        }

        public BlockStatePredicate build() {
            Predicate<BlockState> blockPredicate;
            if (this.block == null) {
                blockPredicate = b -> true;
            } else if (this.tag) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)ResourceLocation.m_135820_((String)this.block.substring(1)));
                blockPredicate = b -> b.m_204336_(tag);
            } else {
                Block block = (Block)Registry.f_122824_.m_7745_(ResourceLocation.m_135820_((String)this.block));
                if (block == Blocks.f_50016_) {
                    throw new IllegalArgumentException("Invalid block: " + this.block);
                }
                blockPredicate = b -> b.m_60713_(block);
            }
            Predicate<BlockState> propertiesPredicate = this.properties.isEmpty() ? b -> true : b -> {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    @NotNull String key = entry.getKey();
                    @Nullable String value = entry.getValue();
                    StateHolderAccess state = (StateHolderAccess)b;
                    @Nullable String blockVal = state.croparia_if$getValue(key);
                    if (value == null && blockVal != null || Objects.equals(blockVal, value)) continue;
                    return false;
                }
                return true;
            };
            this.built = true;
            return new BlockStatePredicate(blockPredicate, propertiesPredicate, Objects.hash(this.block, this.properties), this);
        }

        @Nullable
        public String getBlock() {
            return this.block;
        }

        protected Builder properties(@NotNull Map<String, String> properties) {
            if (this.built) {
                throw new IllegalStateException("Builder already built");
            }
            properties.forEach(this::property);
            return this;
        }

        public Builder block(@Nullable String block) {
            if (this.built) {
                throw new IllegalStateException("Builder already built");
            }
            this.block = block;
            this.tag = block != null && block.startsWith("#");
            return this;
        }

        public Builder property(@NotNull String property, @Nullable Object value) {
            if (this.built) {
                throw new IllegalStateException("Builder already built");
            }
            this.properties.put(property, value == null ? null : value.toString());
            return this;
        }

        public boolean isBlock() {
            return this.block != null && !this.tag;
        }

        public boolean isTag() {
            return this.tag;
        }
    }
}

