/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.TagUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericIngredient
implements Predicate<ItemStack> {
    public static final Codec<GenericIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("id").forGetter(GenericIngredient::getId), (App)ResourceLocation.f_135803_.optionalFieldOf("tag").forGetter(GenericIngredient::getTag), (App)Codec.INT.optionalFieldOf("count").forGetter(ingredient -> Optional.of(ingredient.getCount())), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(GenericIngredient::getNbt)).apply((Applicative)instance, (id, rawTag, optionalCount, optionalNbt) -> {
        int count = optionalCount.orElse(1);
        CompoundTag nbt = optionalNbt.orElse(null);
        AtomicReference ingredient = new AtomicReference();
        id.map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7745_(arg_0)).map(item -> new GenericIngredient((Item)item, count, nbt)).ifPresentOrElse(ingredient::set, () -> rawTag.map(raw -> TagKey.m_203882_((ResourceKey)Registry.f_122827_.m_123023_(), (ResourceLocation)raw)).ifPresentOrElse(tag -> ingredient.set(new GenericIngredient((TagKey<Item>)tag, count, nbt)), () -> ingredient.set(new GenericIngredient(count, nbt))));
        return (GenericIngredient)ingredient.get();
    }));
    @Nullable
    private final Item item;
    @Nullable
    private final TagKey<Item> tag;
    private final int count;
    @Nullable
    private final CompoundTag nbt;

    public GenericIngredient(int count, @Nullable CompoundTag nbt) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        this.item = null;
        this.tag = null;
        this.count = count;
        this.nbt = nbt;
    }

    public GenericIngredient(@NotNull TagKey<Item> tag) {
        this.item = null;
        this.tag = tag;
        this.count = 1;
        this.nbt = null;
    }

    public GenericIngredient(@NotNull Item item) {
        if (item == Items.f_41852_) {
            item = null;
        }
        this.item = item;
        this.tag = null;
        this.count = 1;
        this.nbt = null;
    }

    public GenericIngredient(@NotNull TagKey<Item> tag, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        this.item = null;
        this.tag = tag;
        this.count = count;
        this.nbt = null;
    }

    public GenericIngredient(@NotNull Item item, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        if (item == Items.f_41852_) {
            item = null;
        }
        this.item = item;
        this.tag = null;
        this.count = count;
        this.nbt = null;
    }

    public GenericIngredient(@NotNull ItemStack stack) {
        this(stack.m_41720_(), stack.m_41613_(), stack.m_41783_());
    }

    public GenericIngredient(@NotNull Item item, int count, @Nullable CompoundTag tag) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        if (item == Items.f_41852_) {
            item = null;
        }
        this.item = item;
        this.tag = null;
        this.count = count;
        this.nbt = tag;
    }

    public GenericIngredient(@NotNull TagKey<Item> tag, int count, @Nullable CompoundTag nbt) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        this.item = null;
        this.tag = tag;
        this.count = count;
        this.nbt = nbt;
    }

    public Optional<ResourceLocation> getId() {
        return this.item != null ? Optional.ofNullable(this.item.arch$registryName()) : Optional.empty();
    }

    public Optional<ResourceLocation> getTag() {
        return this.tag != null ? Optional.of(this.tag.f_203868_()) : Optional.empty();
    }

    public int getCount() {
        return this.count;
    }

    public Optional<CompoundTag> getNbt() {
        return Optional.ofNullable(this.nbt);
    }

    public Optional<Component> nbtTooltip() {
        if (this.nbt == null) {
            return Optional.empty();
        }
        return Optional.of(new TextComponent(this.nbt.toString()));
    }

    @NotNull
    public List<ItemStack> availableStacks() {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        if (this.item != null) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            stack.m_41751_(this.nbt);
            stacks.add(stack);
        } else if (this.tag != null) {
            for (Holder<Item> holder : TagUtil.forItems(this.tag)) {
                ItemStack stack = new ItemStack((ItemLike)holder.m_203334_(), this.count);
                stack.m_41751_(this.nbt);
                stacks.add(stack);
            }
        } else {
            ItemStack stack = new ItemStack((ItemLike)CropariaItems.PLACEHOLDER.get(), this.count);
            stack.m_41751_(this.nbt);
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        if (this.count > itemStack.m_41613_()) {
            return false;
        }
        if (this.item != null && itemStack.m_41720_() != this.item) {
            return false;
        }
        if (this.tag != null && !itemStack.m_204117_(this.tag)) {
            return false;
        }
        return GenericIngredient.matchNbt((Tag)this.nbt, (Tag)itemStack.m_41783_());
    }

    private static boolean matchNbt(@Nullable Tag primary, @Nullable Tag secondary) {
        if (primary == null) {
            return true;
        }
        if (secondary == null) {
            return false;
        }
        if (primary instanceof CompoundTag) {
            CompoundTag primaryCompound = (CompoundTag)primary;
            if (secondary instanceof CompoundTag) {
                CompoundTag secondaryCompound = (CompoundTag)secondary;
                for (String key : primaryCompound.m_128431_()) {
                    Tag secondaryTag;
                    Tag primaryTag = primaryCompound.m_128423_(key);
                    if (GenericIngredient.matchNbt(primaryTag, secondaryTag = secondaryCompound.m_128423_(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (primary instanceof CollectionTag) {
            CollectionTag primaryCollection = (CollectionTag)primary;
            if (secondary instanceof CollectionTag) {
                CollectionTag secondaryCollection = (CollectionTag)secondary;
                for (int i = 0; i < primaryCollection.size(); ++i) {
                    Tag secondaryTag;
                    Tag primaryTag = (Tag)primaryCollection.get(i);
                    if (GenericIngredient.matchNbt(primaryTag, secondaryTag = (Tag)secondaryCollection.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return primary.equals((Object)secondary);
    }
}

