/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.core.recipe.serializer;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cool.muyucloud.croparia.api.core.recipe.InfusorRecipe;
import cool.muyucloud.croparia.api.core.recipe.predicate.GenericIngredient;
import cool.muyucloud.croparia.api.element.ElementsEnum;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class InfusorRecipeSerializer
implements RecipeSerializer<InfusorRecipe> {
    private ResourceLocation registryName;

    @NotNull
    public InfusorRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
        ElementsEnum element = ElementsEnum.valueOf(jsonObject.get("element").getAsString().toUpperCase());
        GenericIngredient ingredient = (GenericIngredient)GenericIngredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("ingredient")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        ItemStack result = (ItemStack)ItemStack.f_41582_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("result")).getOrThrow(false, msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        InfusorRecipe recipe = new InfusorRecipe();
        recipe.setId(id);
        recipe.setElement(element);
        recipe.setIngredient(ingredient);
        recipe.setResult(result);
        return recipe;
    }

    @NotNull
    public InfusorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        ElementsEnum element = (ElementsEnum)buf.m_130066_(ElementsEnum.class);
        GenericIngredient ingredient = (GenericIngredient)buf.m_130057_(GenericIngredient.CODEC);
        ItemStack result = buf.m_130267_();
        InfusorRecipe recipe = new InfusorRecipe();
        recipe.setId(id);
        recipe.setElement(element);
        recipe.setIngredient(ingredient);
        recipe.setResult(result);
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf friendlyByteBuf, InfusorRecipe recipe) {
        friendlyByteBuf.m_130068_((Enum)recipe.getElement());
        friendlyByteBuf.m_130059_(GenericIngredient.CODEC, (Object)recipe.getIngredient());
        friendlyByteBuf.m_130055_(recipe.getResult());
    }

    public Object setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

