/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.annotation.PostGen;
import cool.muyucloud.croparia.annotation.PostReg;
import cool.muyucloud.croparia.api.crop.CropType;
import cool.muyucloud.croparia.api.crop.RawCrop;
import cool.muyucloud.croparia.api.crop.block.CropariaCropBlock;
import cool.muyucloud.croparia.api.generator.PlaceHolder;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.util.BiOptional;
import cool.muyucloud.croparia.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Crop {
    @NotNull
    private final String name;
    @NotNull
    private final ResourceLocation material;
    @NotNull
    private final CropType type;
    @NotNull
    private final String translationKey;
    @NotNull
    private final Map<String, String> translations;
    private final int color;
    private final int tier;
    @NotNull
    private final transient ResourceLocation blockId;
    @NotNull
    private final transient ResourceLocation seedId;
    @NotNull
    private final transient ResourceLocation fruitId;
    private final transient boolean tag;
    private static final Pattern CROPARIA = Pattern.compile("\\{croparia}");
    private static final Pattern CROPARIA_PATH = Pattern.compile("\\{croparia_path}");
    private static final Pattern NAME = Pattern.compile("\\{name}");
    private static final Pattern MATERIAL = Pattern.compile("\\{material}");
    private static final Pattern MATERIAL_PATH = Pattern.compile("\\{material_path}");
    private static final Pattern MATERIAL_TYPE = Pattern.compile("\\{material_type}");
    private static final Pattern MATERIAL_TAGGABLE = Pattern.compile("\\{material_taggable}");
    private static final Pattern COLOR = Pattern.compile("\\{color}");
    private static final Pattern COLOR_HEX = Pattern.compile("\\{color_hex}");
    private static final Pattern TYPE = Pattern.compile("\\{type}");
    private static final Pattern TIER = Pattern.compile("\\{tier}");
    private static final Pattern SEED = Pattern.compile("\\{seed}");
    private static final Pattern SEED_PATH = Pattern.compile("\\{seed_path}");
    private static final Pattern FRUIT = Pattern.compile("\\{fruit}");
    private static final Pattern FRUIT_PATH = Pattern.compile("\\{fruit_path}");
    private static final Pattern CROP_BLOCK = Pattern.compile("\\{crop_block}");
    private static final Pattern CROP_BLOCK_PATH = Pattern.compile("\\{crop_block_path}");
    private static final Pattern RESULT = Pattern.compile("\\{result}");
    private static final Pattern RESULT_COUNT = Pattern.compile("\\{result_count\\.(\\d+)}");
    private static final Pattern RESULT_PATH = Pattern.compile("\\{result_path}");
    private static final Pattern TRANSLATION_KEY = Pattern.compile("\\{translation_key}");
    private static final Pattern TRANSLATIONS = Pattern.compile("\\{translations\\.([^}]+)}");

    private Crop(@NotNull RawCrop raw) throws RuntimeException {
        if (Util.anyNull(raw.name, raw.material)) {
            throw new IllegalArgumentException("Crop name and material ID cannot be null");
        }
        this.name = Crop.parseName(raw.name);
        this.material = Crop.parseMaterialId(raw.material, raw.tag);
        this.type = Crop.parseType(raw.type);
        this.translationKey = raw.translationKey == null ? "crop.croparia." + this.name : raw.translationKey;
        this.translations = raw.translationKey == null || raw.isTranslationSpecified() ? Crop.parseTranslation(raw.translations, Crop.parseDefaultTranslation(this.name)) : Collections.emptyMap();
        this.color = raw.color.startsWith("0x") ? Integer.parseInt(raw.color.substring(2), 16) : Integer.parseInt(raw.color);
        this.tier = Crop.parseTier(raw.tier);
        this.tag = raw.material.trim().startsWith("#");
        this.blockId = CropariaIf.of("block_crop_" + this.name);
        this.seedId = CropariaIf.of("seed_crop_" + this.name);
        this.fruitId = CropariaIf.of("fruit_" + this.name);
    }

    private Crop(@NotNull String name, @NotNull String material, int color, int tier, @Nullable CropType type, @Nullable Map<String, String> translations, @Nullable String translationKey) throws RuntimeException {
        this.name = Crop.parseName(name);
        this.material = Crop.parseMaterialId(material, null);
        this.color = color;
        this.tier = Crop.parseTier(tier);
        this.type = type == null ? CropType.CROP : type;
        this.translationKey = translationKey == null ? "crop.croparia." + this.name : translationKey;
        this.translations = translationKey == null || translations != null && !translations.isEmpty() ? Crop.parseTranslation(translations, Crop.parseDefaultTranslation(this.name)) : Collections.emptyMap();
        this.tag = material.trim().startsWith("#");
        this.blockId = CropariaIf.of("block_crop_" + this.name);
        this.seedId = CropariaIf.of("seed_crop_" + this.name);
        this.fruitId = CropariaIf.of("fruit_" + this.name);
    }

    public static Optional<Crop> of(@NotNull RawCrop raw) {
        try {
            return Optional.of(new Crop(raw));
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to create crop %s".formatted(raw.name), e);
            return Optional.empty();
        }
    }

    public static Optional<Crop> create(@NotNull String name, @NotNull String material, int color, int tier, @Nullable CropType type, @Nullable String translationKey, @Nullable Map<String, String> translations) {
        try {
            return Optional.of(new Crop(name, material, color, tier, type, translations, translationKey));
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to create crop %s".formatted(name), e);
            return Optional.empty();
        }
    }

    public static Optional<Crop> create(@NotNull String name, @NotNull String material, int color, int tier, @Nullable CropType type) {
        try {
            return Optional.of(new Crop(name, material, color, tier, type, null, null));
        }
        catch (Throwable e) {
            CropariaIf.LOGGER.error("Failed to create crop %s".formatted(name), e);
            return Optional.empty();
        }
    }

    public Optional<Crop> forModified(@Nullable String material, @Nullable Integer color, @Nullable Integer tier, @Nullable CropType type, @Nullable Map<String, String> translations, @Nullable String translationKey) {
        material = material == null ? this.taggableMaterial() : material;
        color = color == null ? this.getColor() : color.intValue();
        tier = tier == null ? this.getTier() : tier.intValue();
        type = type == null ? this.getType() : type;
        HashMap<String, String> mergedTranslations = new HashMap<String, String>(this.getTranslations());
        if (translations != null) {
            mergedTranslations.putAll(translations);
        }
        translationKey = translationKey == null ? this.getTranslationKey() : translationKey;
        return Crop.create(this.getName(), material, color, tier, type, translationKey, mergedTranslations);
    }

    @NotNull
    protected static String parseName(@NotNull String name) {
        if (ResourceLocation.m_135830_((String)(name = name.trim().toLowerCase()))) {
            return name;
        }
        throw new IllegalArgumentException("Crop name must be a valid resource location");
    }

    @NotNull
    protected static ResourceLocation parseMaterialId(@Nullable String material, @Nullable String tag) {
        AtomicReference id = new AtomicReference();
        BiOptional.of(material, tag).ifEither(l -> {
            if (l.startsWith("#")) {
                l = l.substring(1);
            }
            id.set(new ResourceLocation(l));
        }, r -> id.set(new ResourceLocation(r)), () -> {
            throw new IllegalArgumentException("Ambiguous material, should declare either material or tag");
        });
        return (ResourceLocation)id.get();
    }

    @NotNull
    protected static CropType parseType(@Nullable String type) {
        return type == null ? CropType.CROP : CropType.valueOf(type.trim().toUpperCase());
    }

    @NotNull
    protected static Map<String, String> parseTranslation(@Nullable Map<String, String> translation, @NotNull String defaultTranslation) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (translation != null) {
            for (Map.Entry<String, String> entry : translation.entrySet()) {
                String key = entry.getKey().trim().toLowerCase();
                String value = entry.getValue();
                map.put(key, value);
            }
        }
        map.putIfAbsent("en_us", defaultTranslation);
        return map;
    }

    @NotNull
    protected static String parseDefaultTranslation(@NotNull String name) {
        name = name.replaceAll("_", " ").trim();
        StringBuilder builder = new StringBuilder();
        for (String token : name.split(" ")) {
            builder.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1)).append(" ");
        }
        return builder.toString().trim();
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.addProperty("name", this.name);
        root.addProperty("material", (this.tag ? "#" : "") + String.valueOf(this.material));
        root.addProperty("color", this.serializeColor());
        root.addProperty("tier", (Number)this.tier);
        root.addProperty("type", this.type.getModelName());
        root.addProperty("translationKey", this.translationKey);
        JsonObject translations = new JsonObject();
        this.translations.forEach((arg_0, arg_1) -> ((JsonObject)translations).addProperty(arg_0, arg_1));
        root.add("translations", (JsonElement)translations);
        return root;
    }

    protected static int parseTier(int tier) {
        if (tier < CropariaItems.leastTier() || tier > CropariaItems.mostTier()) {
            CropariaIf.LOGGER.warn("Crop tier {} is out of range, defaulting to 1", (Object)tier);
            return 1;
        }
        return tier;
    }

    @NotNull
    public CropType getType() {
        return this.type;
    }

    public String taggableMaterial() {
        return (this.tag ? "#" : "") + String.valueOf(this.material);
    }

    @NotNull
    public Item getMaterialItem() {
        if (this.tag) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)this.material);
            Iterable set = Registry.f_122827_.m_206058_(tag);
            if (set.iterator().hasNext()) {
                return (Item)((Holder)set.iterator().next()).m_203334_();
            }
        } else {
            return (Item)Registry.f_122827_.m_7745_(this.material);
        }
        return Items.f_41852_;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getColor() {
        return this.color;
    }

    public String serializeColor() {
        Object hex = Integer.toHexString(this.color);
        hex = "0".repeat(6 - ((String)hex).length()) + (String)hex;
        return "0x" + (String)hex;
    }

    public int getTier() {
        return this.tier;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ResourceLocation getBlockId() {
        return this.blockId;
    }

    @NotNull
    @PostReg
    public CropariaCropBlock getCropBlock() {
        return (CropariaCropBlock)Registry.f_122824_.m_7745_(this.blockId);
    }

    @NotNull
    public ResourceLocation getSeedId() {
        return this.seedId;
    }

    @NotNull
    @PostReg
    public Item getSeedItem() {
        return (Item)Registry.f_122827_.m_7745_(this.seedId);
    }

    @NotNull
    public ResourceLocation getFruitId() {
        return this.fruitId;
    }

    @NotNull
    @PostReg
    public Item getFruitItem() {
        return (Item)Registry.f_122827_.m_7745_(this.fruitId);
    }

    @NotNull
    public Set<String> availableLangs() {
        return Set.copyOf(this.translations.keySet());
    }

    @NotNull
    public String translate(@Nullable String lang) {
        return this.translations.getOrDefault(lang, this.translations.get("en_us"));
    }

    @NotNull
    public ResourceLocation getMaterial() {
        return this.material;
    }

    public boolean isTag() {
        return this.tag;
    }

    protected Map<String, String> getTranslations() {
        return Map.copyOf(this.translations);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Crop{name='" + this.name + "', material=" + String.valueOf(this.material) + ", type=" + String.valueOf((Object)this.type) + ", translationKey='" + this.translationKey + "', translations=" + String.valueOf(this.translations) + ", color=" + this.color + ", tier=" + this.tier + ", tag=" + this.tag + "}";
    }

    @PostGen
    public Map<Pattern, PlaceHolder> placeholders() {
        HashMap<Pattern, PlaceHolder> map = new HashMap<Pattern, PlaceHolder>();
        map.put(COLOR, placeholder -> Integer.toString(this.color));
        map.put(COLOR_HEX, placeholder -> Integer.toHexString(this.color));
        map.put(CROPARIA, placeholder -> CropariaItems.getCroparia(this.getTier()).getId().toString());
        map.put(CROPARIA_PATH, placeholder -> CropariaItems.getCroparia(this.getTier()).getId().m_135815_());
        map.put(CROP_BLOCK, placeholder -> this.getBlockId().toString());
        map.put(CROP_BLOCK_PATH, placeholder -> this.getBlockId().m_135815_());
        map.put(FRUIT, placeholder -> this.getFruitId().toString());
        map.put(FRUIT_PATH, placeholder -> this.getFruitId().m_135815_());
        map.put(MATERIAL, placeholder -> this.getMaterial().toString());
        map.put(MATERIAL_PATH, placeholder -> this.getMaterial().m_135815_());
        map.put(MATERIAL_TYPE, placeholder -> this.isTag() ? "tag" : "item");
        map.put(MATERIAL_TAGGABLE, placeholder -> this.taggableMaterial());
        map.put(NAME, placeholder -> this.name);
        map.put(SEED, placeholder -> this.getSeedId().toString());
        map.put(SEED_PATH, placeholder -> this.getSeedId().m_135815_());
        map.put(RESULT, placeholder -> Objects.requireNonNull(this.getMaterialItem().arch$registryName()).toString());
        map.put(RESULT_COUNT, placeholder -> {
            Matcher matcher = RESULT_COUNT.matcher(placeholder);
            if (matcher.find()) {
                int count = Integer.parseInt(matcher.group(1));
                return String.valueOf(Math.min(this.getMaterialItem().m_41459_(), count));
            }
            throw new RuntimeException("Invalid result count placeholder: " + placeholder);
        });
        map.put(RESULT_PATH, placeholder -> Objects.requireNonNull(this.getMaterialItem().arch$registryName()).m_135815_());
        map.put(TIER, placeholder -> Integer.toString(this.tier));
        map.put(TYPE, placeholder -> this.type.getModelName());
        map.put(TRANSLATION_KEY, placeholder -> this.translationKey);
        map.put(TRANSLATIONS, placeholder -> {
            Matcher matcher = TRANSLATIONS.matcher(placeholder);
            if (matcher.find()) {
                return this.translate(matcher.group(1));
            }
            throw new RuntimeException("Invalid translation placeholder: " + placeholder);
        });
        return map;
    }
}

