/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.RawCrop;
import cool.muyucloud.croparia.registry.Crops;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class CropFileHandler {
    private static final Gson GSON = new Gson();

    @NotNull
    public static List<RawCrop> readCrops() {
        File[] files;
        LinkedList<RawCrop> crops = new LinkedList<RawCrop>();
        File folder = CropariaIf.CONFIG.getCropPath().toFile();
        if (folder.exists() && folder.isDirectory() && (files = folder.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : files) {
                Optional<RawCrop> crop = CropFileHandler.readCrop(file);
                crop.ifPresent(crops::add);
            }
        }
        return crops;
    }

    public static Optional<RawCrop> readCrop(File file) {
        Optional<RawCrop> optional;
        FileReader reader = new FileReader(file);
        try {
            optional = Optional.ofNullable((RawCrop)GSON.fromJson((Reader)reader, RawCrop.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CropariaIf.LOGGER.error("Invalid crop file \"%s\"".formatted(file), (Throwable)e);
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static void dumpCrops() {
        Path dir = CropariaIf.CONFIG.getDumpPath().resolve("crops");
        File dirFile = dir.toFile();
        if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(dir));
        }
        Crops.forEachCrop(crop -> {
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(dir.resolve(crop.getName() + ".json").toFile()));){
                writer.setIndent("  ");
                GSON.toJson((JsonElement)crop.toJson(), writer);
            }
            catch (Throwable e) {
                CropariaIf.LOGGER.error("Failed to dump crop \"%s\"".formatted(crop.getName()), e);
            }
        });
    }

    public static void dumpBuiltinCrops() {
        Path dir = CropariaIf.CONFIG.getDumpPath().resolve("builtin_crops");
        File dirFile = dir.toFile();
        if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(dir));
        }
        Crops.forEachBuiltinCrop(crop -> {
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(dir.resolve(crop.getName() + ".json").toFile()));){
                writer.setIndent("  ");
                GSON.toJson((JsonElement)crop.toJson(), writer);
            }
            catch (Throwable e) {
                CropariaIf.LOGGER.error("Failed to dump crop \"%s\"".formatted(crop.getName()), e);
            }
        });
    }

    public static boolean dumpCrop(@NotNull Crop crop) {
        boolean bl;
        Path dir = CropariaIf.CONFIG.getDumpPath().resolve("crops");
        File dirFile = dir.toFile();
        if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(dir));
        }
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(dir.resolve(crop.getName() + ".json").toFile()));
        try {
            writer.setIndent("  ");
            GSON.toJson((JsonElement)crop.toJson(), writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                CropariaIf.LOGGER.error("Failed to dump crop \"%s\"".formatted(crop.getName()), e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean containsFile(String name) {
        return CropariaIf.CONFIG.getCropPath().resolve(name + ".json").toFile().isFile();
    }
}

