/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.command;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.CropFileHandler;
import cool.muyucloud.croparia.api.crop.CropType;
import cool.muyucloud.croparia.api.crop.RawCrop;
import cool.muyucloud.croparia.api.crop.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.crop.command.FailureMessage;
import cool.muyucloud.croparia.api.crop.command.SuccessMessage;
import cool.muyucloud.croparia.api.crop.item.Croparia;
import cool.muyucloud.croparia.registry.Crops;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CreateCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> CREATE = Commands.m_82127_((String)"create");
    private static final RequiredArgumentBuilder<CommandSourceStack, String> TYPE = RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<CommandSourceStack, String> COLOR = RequiredArgumentBuilder.argument((String)"color", (ArgumentType)StringArgumentType.word());
    private static final RequiredArgumentBuilder<CommandSourceStack, String> NAME = RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word());
    private static final LiteralArgumentBuilder<CommandSourceStack> REPLACE = LiteralArgumentBuilder.literal((String)"replace");

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return CREATE;
    }

    public static int create(Player player, String name, String rawType, String color, SuccessMessage success, FailureMessage failure, boolean client, boolean replaced) {
        CropType type;
        try {
            type = CropType.valueOf(rawType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            failure.send((Component)new TranslatableComponent("commands.croparia.create.invalid_type", new Object[]{rawType}));
            return -1;
        }
        ItemStack main = player.m_21205_();
        if (main.m_41619_()) {
            failure.send((Component)new TranslatableComponent("commands.croparia.create.no_material"));
            return -1;
        }
        Item material = main.m_41720_();
        Item rawCroparia = player.m_21206_().m_41720_();
        String string = name = name == null ? Objects.requireNonNull(material.arch$registryName()).m_135815_() : name;
        if (ResourceLocation.m_135820_((String)name) == null) {
            failure.send((Component)new TranslatableComponent("commands.croparia.create.invalid_name", new Object[]{name}));
            return -1;
        }
        try {
            if (color.startsWith("#")) {
                Integer.parseInt(color.substring(1), 16);
            } else if (color.startsWith("0x")) {
                Integer.parseInt(color.substring(2), 16);
            } else {
                Integer.parseInt(color, 10);
            }
        }
        catch (NumberFormatException e) {
            failure.send((Component)new TranslatableComponent("commands.croparia.create.invalid_color", new Object[]{color}));
            return -1;
        }
        if (!replaced && (Crops.containsCrop(name) || CropFileHandler.containsFile(name))) {
            TextComponent crop = new TextComponent(name);
            if (Crops.containsCrop(name)) {
                crop.m_130948_(CommonCommandRoot.runCommand(CommonCommandRoot.commandRoot(client), "crop", name)).m_130948_(CommonCommandRoot.inlineMouseBehavior());
            }
            MutableComponent rename = new TranslatableComponent("commands.croparia.create.duplicated.rename", new Object[]{name}).m_130948_(CommonCommandRoot.suggestCommand(CommonCommandRoot.commandRoot(client), "create", color, rawType, name + "_")).m_130948_(CommonCommandRoot.inlineMouseBehavior());
            MutableComponent replace = new TranslatableComponent("commands.croparia.create.duplicated.replace").m_130948_(CommonCommandRoot.suggestCommand(CommonCommandRoot.commandRoot(client), "create", color, rawType, name, "replace")).m_130948_(CommonCommandRoot.inlineMouseBehavior());
            TranslatableComponent duplication = new TranslatableComponent("commands.croparia.create.duplicated", new Object[]{crop, rename, replace});
            failure.send((Component)duplication);
            return -1;
        }
        if (rawCroparia instanceof Croparia) {
            Croparia croparia = (Croparia)rawCroparia;
            JsonObject built = CreateCommand.buildCrop(name, material, color, croparia.getTier(), type);
            Path result = CreateCommand.dump(built);
            TextComponent resultComponent = new TextComponent(result.toString());
            if (client) {
                resultComponent.m_130948_(CommonCommandRoot.openFile(result.toString())).m_130948_(CommonCommandRoot.inlineMouseBehavior());
            }
            success.send((Component)new TranslatableComponent("commands.croparia.create.success", new Object[]{resultComponent}), true);
            return croparia.getTier();
        }
        failure.send((Component)new TranslatableComponent("commands.croparia.create.invalid_croparia"));
        return -1;
    }

    public static JsonObject buildCrop(String name, Item material, String color, int tier, CropType type) {
        String materialId = Objects.requireNonNull(material.arch$registryName()).toString();
        String translationKey = material.m_5524_();
        String dependency = Objects.requireNonNull(material.arch$registryName()).m_135827_();
        RawCrop crop = new RawCrop(name, materialId, null, type.getModelName(), translationKey, color, tier, null, List.of(List.of(dependency)));
        return new Gson().toJsonTree((Object)crop).getAsJsonObject();
    }

    public static Path dump(JsonObject built) {
        Path path;
        Path parent = CropariaIf.CONFIG.getCropPath();
        if (!parent.toFile().isDirectory() && !parent.toFile().mkdirs()) {
            throw new IllegalStateException("Failed to establish directory \"%s\"".formatted(parent));
        }
        Path location = parent.resolve(built.get("name").getAsString() + ".json");
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(location.toFile()));
        try {
            writer.setIndent("  ");
            new Gson().toJson((JsonElement)built, writer);
            path = location;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return path;
    }

    static {
        CREATE.requires(s -> s.m_6761_(2));
        COLOR.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).m_81375_(), null, CropType.CROP.getModelName(), StringArgumentType.getString((CommandContext)context, (String)"color"), (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0), false, false));
        TYPE.suggests((context, builder) -> {
            for (CropType type : CropType.values()) {
                builder.suggest(type.getModelName());
            }
            return builder.buildFuture();
        }).executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).m_81375_(), null, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0), false, false));
        NAME.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0), false, false));
        REPLACE.executes(context -> CreateCommand.create((Player)((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"color"), (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0), false, true));
        NAME.then(REPLACE);
        TYPE.then(NAME);
        COLOR.then(TYPE);
        CREATE.then(COLOR);
    }
}

