/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.access.CropAccess;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.crop.command.FailureMessage;
import cool.muyucloud.croparia.api.crop.command.SuccessMessage;
import cool.muyucloud.croparia.registry.CropariaItems;
import cool.muyucloud.croparia.registry.Crops;
import cool.muyucloud.croparia.util.Util;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class CropCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> CROP = (LiteralArgumentBuilder)Commands.m_82127_((String)"crop").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> Crops.suggestCrops(builder)).executes(context -> {
        String name = StringArgumentType.getString((CommandContext)context, (String)"name");
        return CropCommand.reportSingular(name, (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0));
    }));

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return CROP;
    }

    public static int reportSingular(String name, SuccessMessage success, FailureMessage failure) {
        Crop crop = Crops.forName(name);
        if (crop == null) {
            failure.send((Component)new TranslatableComponent("commands.croparia.crop.absent", new Object[]{name}));
            return 0;
        }
        MutableComponent report = CropCommand.buildReport(crop);
        success.send((Component)report, false);
        return crop.getTier();
    }

    public static int reportForPlayer(Player player, Level world, SuccessMessage success, FailureMessage failure) {
        CropAccess cropAccess;
        Item item = player.m_21205_().m_41720_();
        if (item instanceof CropAccess) {
            CropAccess tmpCropAccess;
            cropAccess = tmpCropAccess = (CropAccess)item;
        } else {
            item = world.m_8055_(Util.lookingAt(player)).m_60734_();
            if (item instanceof CropAccess) {
                CropAccess tmpCropAccess;
                cropAccess = tmpCropAccess = (CropAccess)item;
            } else {
                failure.send((Component)new TranslatableComponent("commands.croparia.crop.no_crop"));
                return 0;
            }
        }
        MutableComponent report = CropCommand.buildReport(cropAccess.getCrop());
        success.send((Component)report, false);
        return cropAccess.getCrop().getTier();
    }

    public static MutableComponent buildReport(@NotNull Crop crop) {
        TranslatableComponent name = new TranslatableComponent("commands.croparia.crop.name", new Object[]{crop.getName()});
        TranslatableComponent translation = new TranslatableComponent("commands.croparia.crop.translation", new Object[]{new TranslatableComponent(crop.getTranslationKey()).m_130948_(CommonCommandRoot.copyText(crop.getTranslationKey()))});
        TranslatableComponent material = new TranslatableComponent("commands.croparia.crop.material", new Object[]{new TextComponent(crop.taggableMaterial()).m_130948_(CommonCommandRoot.suggestCommand("give @s", Objects.requireNonNull(crop.getMaterialItem().arch$registryName()).toString())).m_130948_(CommonCommandRoot.hoverItem(crop.getMaterialItem().arch$registryName())).m_130948_(CommonCommandRoot.inlineMouseBehavior())});
        TranslatableComponent tier = new TranslatableComponent("commands.croparia.crop.tier", new Object[]{new TextComponent("" + crop.getTier()).m_130948_(CommonCommandRoot.suggestCommand("give @s", CropariaItems.getCroparia(crop.getTier()).getId().toString())).m_130948_(CommonCommandRoot.hoverItem((Item)CropariaItems.getCroparia(crop.getTier()).get())).m_130948_(CommonCommandRoot.inlineMouseBehavior())});
        TranslatableComponent color = new TranslatableComponent("commands.croparia.crop.color", new Object[]{new TextComponent(crop.serializeColor()).m_130948_(CommonCommandRoot.color(crop.getColor())).m_130948_(CommonCommandRoot.copyText(crop.serializeColor()))});
        TranslatableComponent type = new TranslatableComponent("commands.croparia.crop.type", new Object[]{new TextComponent(crop.getType().getModelName()).m_130948_(CommonCommandRoot.copyText(crop.getType().getModelName()))});
        TranslatableComponent seed = new TranslatableComponent("commands.croparia.crop.seed", new Object[]{new TextComponent(crop.getSeedId().toString()).m_130948_(CommonCommandRoot.suggestCommand("give @s", crop.getSeedId().toString())).m_130948_(CommonCommandRoot.hoverItem(crop.getSeedItem())).m_130948_(CommonCommandRoot.inlineMouseBehavior())});
        TranslatableComponent fruit = new TranslatableComponent("commands.croparia.crop.fruit", new Object[]{new TextComponent(crop.getFruitId().toString()).m_130948_(CommonCommandRoot.suggestCommand("give @s", crop.getFruitId().toString())).m_130948_(CommonCommandRoot.hoverItem(crop.getFruitItem())).m_130948_(CommonCommandRoot.inlineMouseBehavior())});
        TranslatableComponent cropBlock = new TranslatableComponent("commands.croparia.crop.cropBlock", new Object[]{new TextComponent(crop.getBlockId().toString()).m_130948_(CommonCommandRoot.suggestCommand("setblock ~ ~ ~", String.valueOf(crop.getBlockId()) + "[age=7]")).m_130948_(CommonCommandRoot.hoverText((Component)crop.getCropBlock().m_49954_())).m_130948_(CommonCommandRoot.inlineMouseBehavior())});
        MutableComponent status = CropCommand.diagnose(crop);
        return name.m_130946_("\n").m_7220_((Component)translation).m_130946_("\n").m_7220_((Component)material).m_130946_("\n").m_7220_((Component)tier).m_130946_("\n").m_7220_((Component)color).m_130946_("\n").m_7220_((Component)type).m_130946_("\n").m_7220_((Component)seed).m_130946_("\n").m_7220_((Component)fruit).m_130946_("\n").m_7220_((Component)cropBlock).m_130946_("\n").m_7220_((Component)status);
    }

    public static MutableComponent diagnose(@NotNull Crop crop) {
        if (crop.getMaterialItem() == Items.f_41852_) {
            return new TranslatableComponent("commands.croparia.crop.status.material").m_130940_(ChatFormatting.RED);
        }
        if (crop.getSeedItem() == Items.f_41852_) {
            return new TranslatableComponent("commands.croparia.crop.status.seed").m_130940_(ChatFormatting.RED);
        }
        if (crop.getFruitItem() == Items.f_41852_) {
            return new TranslatableComponent("commands.croparia.crop.status.fruit").m_130940_(ChatFormatting.RED);
        }
        if (crop.getCropBlock() == Blocks.f_50016_) {
            return new TranslatableComponent("commands.croparia.crop.status.crop_block").m_130940_(ChatFormatting.RED);
        }
        return new TranslatableComponent("commands.croparia.crop.status.good").m_130940_(ChatFormatting.GREEN);
    }
}

