/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.crop.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.crop.Crop;
import cool.muyucloud.croparia.api.crop.CropFileHandler;
import cool.muyucloud.croparia.api.crop.command.CommonCommandRoot;
import cool.muyucloud.croparia.api.crop.command.FailureMessage;
import cool.muyucloud.croparia.api.crop.command.SuccessMessage;
import cool.muyucloud.croparia.registry.Crops;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class DumpCommand {
    private static final LiteralArgumentBuilder<CommandSourceStack> DUMP = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires(s -> s.m_6761_(2))).executes(context -> DumpCommand.dumpAll((arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), false))).then(Commands.m_82129_((String)"crop", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> Crops.suggestCrops(builder)).executes(context -> {
        String name = StringArgumentType.getString((CommandContext)context, (String)"crop");
        return DumpCommand.dump(name, (arg_0, arg_1) -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81354_(arg_0, arg_1), arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_81352_(arg_0), false);
    }));

    public static int dumpAll(SuccessMessage success, boolean openFile) {
        int size = Crops.size();
        TranslatableComponent component = new TranslatableComponent("commands.croparia.dump.perform", new Object[]{size});
        if (openFile) {
            component.m_130948_(CommonCommandRoot.openFile(CropariaIf.CONFIG.getDumpPath().toString())).m_130948_(CommonCommandRoot.blockMouseBehavior());
        }
        success.send((Component)component, true);
        CropFileHandler.dumpCrops();
        return Crops.size();
    }

    public static int dump(String name, SuccessMessage success, FailureMessage failure, boolean openFile) {
        Crop crop = Crops.forName(name);
        if (crop == null) {
            TranslatableComponent component = new TranslatableComponent("commands.croparia.dump.singular.absent", new Object[]{name});
            failure.send((Component)component);
            return 0;
        }
        if (CropFileHandler.dumpCrop(crop)) {
            TextComponent nameComponent = new TextComponent(name);
            if (openFile) {
                nameComponent.m_130948_(CommonCommandRoot.openFile(CropariaIf.CONFIG.getDumpPath().resolve(name + ".json").toString())).m_130948_(CommonCommandRoot.blockMouseBehavior());
            }
            TranslatableComponent component = new TranslatableComponent("commands.croparia.dump.singular", new Object[]{nameComponent});
            success.send((Component)component, true);
            return 1;
        }
        failure.send((Component)new TranslatableComponent("commands.croparia.dump.singular.fail", new Object[]{name}));
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return DUMP;
    }
}

